/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.resolver.method;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiMethod;
import com.sheldon.idea.plugin.api.method.AsyncTestVariableNode;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.service.SpringClassName;
import com.sheldon.idea.plugin.api.utils.build.resolver.AnnotationResolver;
import com.sheldon.idea.plugin.api.utils.build.resolver.ResolverHelper;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/method/SpringMethodAnnotationResolver;", "", "<init>", "()V", "resolve", "Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "method", "Lcom/intellij/psi/PsiMethod;", "mergeInfo", "genericInfo", "specificInfo", "Companion", "idea-plugin"})
public final class SpringMethodAnnotationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final ApiRequest resolve(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiAnnotation genericAnnotation = null;
        PsiAnnotation specificAnnotation = null;
        PsiMethod psiMethod = AnnotationResolver.INSTANCE.findMethodWithMapping(method);
        if (psiMethod == null) {
            return null;
        }
        PsiMethod annotationMethod = psiMethod;
        for (PsiAnnotation annotation : annotationMethod.getAnnotations()) {
            String qName;
            if (annotation.getQualifiedName() == null) continue;
            if (Intrinsics.areEqual((Object)qName, (Object)"org.springframework.web.bind.annotation.RequestMapping")) {
                genericAnnotation = annotation;
                continue;
            }
            if (!SpringClassName.INSTANCE.getSPRING_SINGLE_REQUEST_MAPPING_ANNOTATIONS().contains(qName) || specificAnnotation != null) continue;
            specificAnnotation = annotation;
        }
        if (genericAnnotation == null && specificAnnotation == null) {
            return null;
        }
        PsiAnnotation psiAnnotation = genericAnnotation;
        ApiRequest genericInfo = psiAnnotation != null ? com.sheldon.idea.plugin.api.utils.build.resolver.method.SpringMethodAnnotationResolver$Companion.parseSingleAnnotation$default(Companion, psiAnnotation, false, 2, null) : new ApiRequest(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
        PsiAnnotation psiAnnotation2 = specificAnnotation;
        ApiRequest specificInfo = psiAnnotation2 != null ? com.sheldon.idea.plugin.api.utils.build.resolver.method.SpringMethodAnnotationResolver$Companion.parseSingleAnnotation$default(Companion, psiAnnotation2, false, 2, null) : new ApiRequest(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
        return this.mergeInfo(genericInfo, specificInfo);
    }

    @NotNull
    public final ApiRequest mergeInfo(@NotNull ApiRequest genericInfo, @NotNull ApiRequest specificInfo) {
        Intrinsics.checkNotNullParameter((Object)genericInfo, (String)"genericInfo");
        Intrinsics.checkNotNullParameter((Object)specificInfo, (String)"specificInfo");
        String string = specificInfo.getMethod();
        if (string == null) {
            string = genericInfo.getMethod();
        }
        String method = string;
        String path = ResolverHelper.Companion.combinePath(genericInfo.getPath(), specificInfo.getPath());
        List headers = ResolverHelper.Companion.mergeHeadersOrParams$default(ResolverHelper.Companion, genericInfo.getHeaders(), specificInfo.getHeaders(), false, SpringMethodAnnotationResolver::mergeInfo$lambda$0, 4, null);
        List params = ResolverHelper.Companion.mergeHeadersOrParams$default(ResolverHelper.Companion, genericInfo.getQuery(), specificInfo.getQuery(), false, null, 8, null);
        specificInfo.setPath(path);
        specificInfo.setMethod(method);
        specificInfo.setQuery(params);
        specificInfo.setHeaders(headers);
        return specificInfo;
    }

    private static final String mergeInfo$lambda$0(AsyncTestVariableNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/method/SpringMethodAnnotationResolver$Companion;", "", "<init>", "()V", "parseSingleAnnotation", "Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "ignoreMethod", "", "idea-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ApiRequest parseSingleAnnotation(@NotNull PsiAnnotation annotation, boolean ignoreMethod) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            String method = null;
            if (!ignoreMethod) {
                SpringClassName.RequestMethod requestMethod = ResolverHelper.Companion.parseRequestMethod(annotation);
                method = requestMethod != null ? requestMethod.name() : null;
            }
            String path = AnnotationResolver.INSTANCE.getPath(annotation);
            List headers = AnnotationResolver.INSTANCE.parseParamsOrHeaders(annotation, "headers", Companion::parseSingleAnnotation$lambda$0);
            AnnotationResolver.parseConsumes$default(AnnotationResolver.INSTANCE, annotation, "consumes", false, arg_0 -> Companion.parseSingleAnnotation$lambda$3(headers, arg_0), 4, null);
            List params = AnnotationResolver.INSTANCE.parseParamsOrHeaders(annotation, "params", Companion::parseSingleAnnotation$lambda$4);
            return new ApiRequest(path, method, headers, params, null, null, null, null, null, null, null, null, 4080, null);
        }

        public static /* synthetic */ ApiRequest parseSingleAnnotation$default(Companion companion, PsiAnnotation psiAnnotation, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.parseSingleAnnotation(psiAnnotation, bl);
        }

        private static final AsyncTestVariableNode parseSingleAnnotation$lambda$0(String k, String v) {
            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            String string = k.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return new AsyncTestVariableNode("string", string, 0, v, null, false, null, null, null, null, null, null, 4084, null);
        }

        private static final boolean parseSingleAnnotation$lambda$3$lambda$1(String $contentTypeKey, AsyncTestVariableNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getName(), (Object)$contentTypeKey);
        }

        private static final boolean parseSingleAnnotation$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean parseSingleAnnotation$lambda$3(List $headers, String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = "content-type".toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String contentTypeKey = string;
            $headers.removeIf(arg_0 -> Companion.parseSingleAnnotation$lambda$3$lambda$2(arg_0 -> Companion.parseSingleAnnotation$lambda$3$lambda$1(contentTypeKey, arg_0), arg_0));
            return $headers.add(new AsyncTestVariableNode("string", "content-type", 0, value, null, false, null, null, null, null, null, null, 4084, null));
        }

        private static final AsyncTestVariableNode parseSingleAnnotation$lambda$4(String k, String v) {
            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            String string = k.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return new AsyncTestVariableNode("string", string, 0, v, null, false, null, null, null, null, null, null, 4084, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

