/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.resolver;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.sheldon.idea.plugin.api.service.SpringClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/ResolverHelper;", "", "<init>", "()V", "Companion", "idea-plugin"})
public final class ResolverHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002JT\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u00162\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u00162\b\b\u0002\u0010\u001a\u001a\u00020\t2\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001cJI\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00162\u0006\u0010\u0011\u001a\u0002H\u00172\b\b\u0002\u0010 \u001a\u00020\t2\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001c\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010%\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fJ\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006)"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/ResolverHelper$Companion;", "", "<init>", "()V", "parseRequestMethod", "Lcom/sheldon/idea/plugin/api/service/SpringClassName$RequestMethod;", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "isMultipartFile", "", "type", "Lcom/intellij/psi/PsiType;", "isSingleFile", "isInheritor", "targetFqn", "", "resolveMethodEnumValues", "element", "Lcom/intellij/psi/PsiElement;", "generateNotEqualValue", "original", "mergeHeadersOrParams", "", "T", "baseList", "overlayList", "distinct", "keySelector", "Lkotlin/Function1;", "addOrUpdateElement", "", "list", "overwrite", "(Ljava/util/List;Ljava/lang/Object;ZLkotlin/jvm/functions/Function1;)V", "combinePath", "base", "sub", "getElementComment", "cleanComment", "text", "debugPsiStructure", "idea-plugin"})
    @SourceDebugExtension(value={"SMAP\nResolverHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolverHelper.kt\ncom/sheldon/idea/plugin/api/utils/build/resolver/ResolverHelper$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,224:1\n13402#2,2:225\n1863#3,2:227\n1863#3,2:229\n360#3,7:231\n1104#4,3:238\n*S KotlinDebug\n*F\n+ 1 ResolverHelper.kt\ncom/sheldon/idea/plugin/api/utils/build/resolver/ResolverHelper$Companion\n*L\n70#1:225,2\n108#1:227,2\n112#1:229,2\n133#1:231,7\n191#1:238,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SpringClassName.RequestMethod parseRequestMethod(@NotNull PsiAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            String string = annotation.getQualifiedName();
            if (string == null) {
                return null;
            }
            String qName = string;
            if (SpringClassName.INSTANCE.getMETHOD_ANNOTATION_MAP().containsKey(qName)) {
                SpringClassName.RequestMethod requestMethod = SpringClassName.INSTANCE.getMETHOD_ANNOTATION_MAP().get(qName);
                Intrinsics.checkNotNull((Object)((Object)requestMethod));
                SpringClassName.RequestMethod method = requestMethod;
                return (SpringClassName.RequestMethod)((Object)CollectionsKt.firstOrNull((List)CollectionsKt.listOf((Object)((Object)method))));
            }
            if (Intrinsics.areEqual((Object)qName, (Object)"org.springframework.web.bind.annotation.RequestMapping")) {
                PsiAnnotationMemberValue psiAnnotationMemberValue = annotation.findAttributeValue("method");
                if (psiAnnotationMemberValue == null) {
                    return null;
                }
                PsiAnnotationMemberValue valueElement = psiAnnotationMemberValue;
                return this.resolveMethodEnumValues((PsiElement)valueElement);
            }
            return null;
        }

        public final boolean isMultipartFile(@NotNull PsiType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (this.isSingleFile(type2)) {
                return true;
            }
            if (type2 instanceof PsiArrayType) {
                PsiType psiType = ((PsiArrayType)type2).getComponentType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getComponentType(...)");
                PsiType itemType = psiType;
                return this.isSingleFile(itemType);
            }
            PsiType itemType = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false);
            if (itemType != null) {
                return this.isSingleFile(itemType);
            }
            return false;
        }

        private final boolean isSingleFile(PsiType type2) {
            return Companion.isInheritor(type2, "org.springframework.web.multipart.MultipartFile") || Companion.isInheritor(type2, "javax.servlet.http.Part") || Companion.isInheritor(type2, "jakarta.servlet.http.Part");
        }

        public final boolean isInheritor(@NotNull PsiType type2, @NotNull String targetFqn) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)targetFqn, (String)"targetFqn");
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (psiClass == null) {
                return false;
            }
            PsiClass psiClass2 = psiClass;
            if (Intrinsics.areEqual((Object)psiClass2.getQualifiedName(), (Object)targetFqn)) {
                return true;
            }
            return InheritanceUtil.isInheritor((PsiClass)psiClass2, (String)targetFqn);
        }

        private final SpringClassName.RequestMethod resolveMethodEnumValues(PsiElement element) {
            List methods = new ArrayList();
            if (element instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = ((PsiArrayInitializerMemberValue)element).getInitializers();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationMemberValueArray, (String)"getInitializers(...)");
                Object[] $this$forEach$iv = psiAnnotationMemberValueArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiAnnotationMemberValue it = (PsiAnnotationMemberValue)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    com.sheldon.idea.plugin.api.utils.build.resolver.ResolverHelper$Companion.resolveMethodEnumValues$extract(methods, (PsiElement)it);
                }
            } else {
                com.sheldon.idea.plugin.api.utils.build.resolver.ResolverHelper$Companion.resolveMethodEnumValues$extract(methods, element);
            }
            return (SpringClassName.RequestMethod)((Object)CollectionsKt.firstOrNull((List)methods));
        }

        private final String generateNotEqualValue(String original) {
            if (((CharSequence)original).length() == 0) {
                return "not_empty";
            }
            char[] cArray = original.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] chars = cArray;
            int lastIndex = ArraysKt.getLastIndex((char[])chars);
            char lastChar = chars[lastIndex];
            chars[lastIndex] = lastChar > '!' ? (char)(lastChar - '\u0001') : (char)(lastChar + '\u0001');
            return new String(chars);
        }

        @NotNull
        public final <T> List<T> mergeHeadersOrParams(@Nullable List<T> baseList, @Nullable List<T> overlayList, boolean distinct, @Nullable Function1<? super T, String> keySelector) {
            String key;
            Object item;
            Object element$iv;
            Iterator iterator;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            List result = new ArrayList();
            if (!distinct) {
                if (baseList != null) {
                    result.addAll((Collection)baseList);
                }
                if (overlayList != null) {
                    result.addAll((Collection)overlayList);
                }
                return result;
            }
            if (keySelector == null) {
                LinkedHashSet set = new LinkedHashSet();
                if (baseList != null) {
                    set.addAll(baseList);
                }
                if (overlayList != null) {
                    set.addAll(overlayList);
                }
                result.addAll(set);
                return result;
            }
            LinkedHashMap map = new LinkedHashMap();
            List<T> list = baseList;
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    item = element$iv = iterator.next();
                    boolean bl = false;
                    key = (String)keySelector.invoke(item);
                    if (!(((CharSequence)key).length() > 0)) continue;
                    ((Map)map).put(key, item);
                }
            }
            List<T> list2 = overlayList;
            if (list2 != null) {
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    item = element$iv = iterator.next();
                    boolean bl = false;
                    key = (String)keySelector.invoke(item);
                    if (!(((CharSequence)key).length() > 0)) continue;
                    ((Map)map).put(key, item);
                }
            }
            Collection collection = map.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            result.addAll(collection);
            return result;
        }

        public static /* synthetic */ List mergeHeadersOrParams$default(Companion companion, List list, List list2, boolean bl, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                function1 = null;
            }
            return companion.mergeHeadersOrParams(list, list2, bl, function1);
        }

        public final <T> void addOrUpdateElement(@NotNull List<T> list, T element, boolean overwrite, @Nullable Function1<? super T, String> keySelector) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (!overwrite) {
                list.add(element);
                return;
            }
            int index = -1;
            if (keySelector != null) {
                String key = (String)keySelector.invoke(element);
                if (((CharSequence)key).length() > 0) {
                    int n;
                    block8: {
                        List<T> $this$indexOfFirst$iv = list;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        Iterator<T> iterator = $this$indexOfFirst$iv.iterator();
                        while (iterator.hasNext()) {
                            T item$iv;
                            T it = item$iv = iterator.next();
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)keySelector.invoke(it), (Object)key)) {
                                n = index$iv;
                                break block8;
                            }
                            ++index$iv;
                        }
                        n = -1;
                    }
                    index = n;
                }
            } else {
                index = list.indexOf(element);
            }
            if (index != -1) {
                list.set(index, element);
            } else {
                list.add(element);
            }
        }

        public static /* synthetic */ void addOrUpdateElement$default(Companion companion, List list, Object object, boolean bl, Function1 function1, int n, Object object2) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                function1 = null;
            }
            companion.addOrUpdateElement(list, object, bl, function1);
        }

        @NotNull
        public final String combinePath(@Nullable String base, @Nullable String sub) {
            String safeSub;
            String string;
            String safeBase;
            String string2 = base;
            if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
                string2 = safeBase = "";
            }
            if ((string = sub) == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                string = safeSub = "";
            }
            if (((CharSequence)safeBase).length() == 0 && ((CharSequence)safeSub).length() == 0) {
                return "";
            }
            String cleanBase = StringsKt.removeSuffix((String)safeBase, (CharSequence)"/");
            String cleanSub = StringsKt.removePrefix((String)safeSub, (CharSequence)"/");
            String combined = ((CharSequence)cleanBase).length() == 0 ? cleanSub : (((CharSequence)cleanSub).length() == 0 ? cleanBase : cleanBase + "/" + cleanSub);
            return !StringsKt.startsWith$default((String)combined, (String)"/", (boolean)false, (int)2, null) ? "/" + combined : combined;
        }

        @NotNull
        public final String getElementComment(@Nullable PsiElement element) {
            if (element == null) {
                return "";
            }
            List comments = new ArrayList();
            if (element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).getDocComment() != null) {
                PsiDocComment psiDocComment = ((PsiDocCommentOwner)element).getDocComment();
                Intrinsics.checkNotNull((Object)psiDocComment);
                PsiElement[] psiElementArray = psiDocComment.getDescriptionElements();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getDescriptionElements(...)");
                CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)ArraysKt.joinToString$default((Object[])psiElementArray, (CharSequence)"", null, null, (int)0, null, Companion::getElementComment$lambda$4, (int)30, null))).toString();
                Regex regex = new Regex("\\n\\s*\\*");
                String string = "\n";
                return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
            }
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiComment) {
                    String string = ((PsiComment)child).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    comments.add(this.cleanComment(string));
                    continue;
                }
                if (!(child instanceof PsiWhiteSpace)) break;
            }
            if (!((Collection)comments).isEmpty()) {
                return CollectionsKt.joinToString$default((Iterable)comments, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
            PsiElement prev = element.getPrevSibling();
            for (int safetyCount = 0; prev != null && safetyCount < 20; prev = prev.getPrevSibling(), ++safetyCount) {
                if (prev instanceof PsiComment) {
                    String string = ((PsiComment)prev).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    comments.add(0, this.cleanComment(string));
                    continue;
                }
                if (prev instanceof PsiWhiteSpace) {
                    String string = ((PsiWhiteSpace)prev).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    CharSequence $this$count$iv = string;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    for (int i = 0; i < $this$count$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$count$iv.charAt(i);
                        boolean bl = false;
                        if (!(it == '\n')) continue;
                        ++count$iv;
                    }
                    if (count$iv <= true) continue;
                    break;
                }
                if (!(prev instanceof PsiAnnotation)) break;
            }
            return CollectionsKt.joinToString$default((Iterable)comments, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final String cleanComment(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)text)).toString();
            Regex regex = new Regex("^//\\s*");
            String string = "";
            charSequence = regex.replace(charSequence, string);
            regex = new Regex("^/\\*+\\s*");
            string = "";
            charSequence = regex.replace(charSequence, string);
            regex = new Regex("\\s*\\*+/$");
            string = "";
            return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
        }

        public final void debugPsiStructure(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            System.out.println((Object)("DEBUG START: \u6b63\u5728\u68c0\u67e5\u5b57\u6bb5 [" + StringsKt.take((String)StringsKt.substringBefore$default((String)string, (String)"\n", null, (int)2, null), (int)20) + "...]"));
            PsiElement prev = element.getPrevSibling();
            for (int count = 0; prev != null && count < 10; prev = prev.getPrevSibling(), ++count) {
                String className = prev.getClass().getSimpleName();
                String string2 = prev.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                String content = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null);
                System.out.println((Object)("   Previous[" + count + "] -> \u7c7b\u578b: " + className + " | \u5185\u5bb9: '" + content + "'"));
            }
            System.out.println((Object)"DEBUG END\n");
        }

        private static final void resolveMethodEnumValues$extract(List<SpringClassName.RequestMethod> methods, PsiElement item) {
            String name;
            SpringClassName.RequestMethod methodEnum;
            if (item instanceof PsiReferenceExpression && (methodEnum = SpringClassName.RequestMethod.Companion.from(name = ((PsiReferenceExpression)item).getReferenceName())) != null) {
                methods.add(methodEnum);
            }
        }

        private static final CharSequence getElementComment$lambda$4(PsiElement it) {
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

