/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.resolver;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.sheldon.idea.plugin.api.service.SpringClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007JI\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u0002H\u000f0\u0014JZ\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0019\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t26\u0010\u0013\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u0002H\u000f0\u001aJ \u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 H\u0002J.\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 H\u0002J&\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 2\b\b\u0002\u0010'\u001a\u00020\u0012J\u001a\u0010(\u001a\u0004\u0018\u00010\u00072\b\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u0010*\u001a\u00020\tJ(\u0010+\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 2\b\b\u0002\u0010'\u001a\u00020\u0012H\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020-J\u000e\u0010/\u001a\u00020\u00122\u0006\u0010.\u001a\u00020-J\u0010\u00100\u001a\u00020\u00122\u0006\u0010.\u001a\u00020-H\u0002JF\u00101\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 2\b\b\u0002\u0010'\u001a\u00020\u00122\u000e\b\u0002\u00102\u001a\b\u0012\u0004\u0012\u00020\t0#H\u0002J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0002\u00a8\u00065"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/AnnotationResolver;", "", "<init>", "()V", "getAnnotationAttribute", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "attrName", "", "getAnnotationAttributeValues", "", "getPath", "parseConsumes", "", "T", "attributeName", "once", "", "factory", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "parseParamsOrHeaders", "", "Lkotlin/Function2;", "key", "resolveForElement", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "targetAnnotations", "", "findRecursively", "visited", "", "hasAnnotations", "psiClass", "Lcom/intellij/psi/PsiClass;", "findAll", "findAnnotationInHierarchy", "psiClassOrMethod", "fqn", "hasTargetAnnotation", "findMethodWithMapping", "Lcom/intellij/psi/PsiMethod;", "method", "isMappingMethod", "hasSpringMapping", "isMetaAnnotated", "foundSoFar", "generateNotEqualValue", "original", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nAnnotationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationResolver.kt\ncom/sheldon/idea/plugin/api/utils/build/resolver/AnnotationResolver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n13402#2,2:305\n1#3:307\n*S KotlinDebug\n*F\n+ 1 AnnotationResolver.kt\ncom/sheldon/idea/plugin/api/utils/build/resolver/AnnotationResolver\n*L\n54#1:305,2\n*E\n"})
public final class AnnotationResolver {
    @NotNull
    public static final AnnotationResolver INSTANCE = new AnnotationResolver();

    private AnnotationResolver() {
    }

    @Nullable
    public final PsiAnnotationMemberValue getAnnotationAttribute(@NotNull PsiAnnotation annotation, @NotNull String attrName) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        return annotation.findAttributeValue(attrName);
    }

    @NotNull
    public final List<String> getAnnotationAttributeValues(@NotNull PsiAnnotation annotation, @NotNull String attrName) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        PsiAnnotationMemberValue psiAnnotationMemberValue = annotation.findAttributeValue(attrName);
        if (psiAnnotationMemberValue == null) {
            return CollectionsKt.emptyList();
        }
        PsiAnnotationMemberValue value = psiAnnotationMemberValue;
        List result = new ArrayList();
        if (value instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = ((PsiArrayInitializerMemberValue)value).getInitializers();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationMemberValueArray, (String)"getInitializers(...)");
            Object[] $this$forEach$iv = psiAnnotationMemberValueArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiAnnotationMemberValue it = (PsiAnnotationMemberValue)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                AnnotationResolver.getAnnotationAttributeValues$extract(result, (PsiElement)it);
            }
        } else {
            AnnotationResolver.getAnnotationAttributeValues$extract(result, (PsiElement)value);
        }
        return result;
    }

    @NotNull
    public final String getPath(@NotNull PsiAnnotation annotation) {
        String string;
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        List<String> list2 = this.getAnnotationAttributeValues(annotation, "value");
        if (list2.isEmpty()) {
            boolean bl = false;
            list = INSTANCE.getAnnotationAttributeValues(annotation, "path");
        } else {
            list = list2;
        }
        if ((string = (String)CollectionsKt.firstOrNull((List)list)) == null) {
            string = "";
        }
        return string;
    }

    public final <T> void parseConsumes(@NotNull PsiAnnotation annotation, @NotNull String attributeName, boolean once, @NotNull Function1<? super String, ? extends T> factory) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        List<String> rawStrings = this.getAnnotationAttributeValues(annotation, attributeName);
        for (String raw : rawStrings) {
            factory.invoke((Object)raw);
            if (!once) continue;
            break;
        }
    }

    public static /* synthetic */ void parseConsumes$default(AnnotationResolver annotationResolver, PsiAnnotation psiAnnotation, String string, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        annotationResolver.parseConsumes(psiAnnotation, string, bl, function1);
    }

    @NotNull
    public final <T> List<T> parseParamsOrHeaders(@NotNull PsiAnnotation annotation, @NotNull String attributeName, @NotNull Function2<? super String, ? super String, ? extends T> factory) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        List result = new ArrayList();
        List<String> rawStrings = this.getAnnotationAttributeValues(annotation, attributeName);
        for (String raw : rawStrings) {
            int it;
            List list;
            int n;
            Object key;
            List parts;
            String constraint = ((Object)StringsKt.trim((CharSequence)raw)).toString();
            if (((CharSequence)constraint).length() == 0) continue;
            if (StringsKt.startsWith$default((String)constraint, (String)"!", (boolean)false, (int)2, null)) {
                Object object;
                if (!StringsKt.contains$default((CharSequence)constraint, (CharSequence)"=", (boolean)false, (int)2, null)) continue;
                String[] stringArray = new String[]{"="};
                parts = StringsKt.split$default((CharSequence)constraint, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                key = StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString(), (CharSequence)"!");
                n = 1;
                list = parts;
                if (n < list.size()) {
                    object = list.get(n);
                } else {
                    it = n;
                    boolean bl = false;
                    object = "";
                }
                String originalValue = ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
                String fakeValue = this.generateNotEqualValue(originalValue);
                result.add(factory.invoke(key, (Object)fakeValue));
                continue;
            }
            if (StringsKt.contains$default((CharSequence)constraint, (CharSequence)"=", (boolean)false, (int)2, null)) {
                Object object;
                key = new String[]{"="};
                parts = StringsKt.split$default((CharSequence)constraint, (String[])key, (boolean)false, (int)2, (int)2, null);
                key = ((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString();
                n = 1;
                list = parts;
                if (n < list.size()) {
                    object = list.get(n);
                } else {
                    it = n;
                    boolean bl = false;
                    object = "";
                }
                String value = ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
                result.add(factory.invoke(key, (Object)value));
                continue;
            }
            result.add(factory.invoke((Object)constraint, (Object)""));
        }
        return result;
    }

    private final PsiAnnotation resolveForElement(PsiModifierListOwner owner, Collection<String> targetAnnotations) {
        Set visited = new LinkedHashSet();
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            Intrinsics.checkNotNull((Object)annotation);
            PsiAnnotation found = this.findRecursively(annotation, visited, targetAnnotations);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private final PsiAnnotation findRecursively(PsiAnnotation annotation, Set<String> visited, Collection<String> targetAnnotations) {
        String string = annotation.getQualifiedName();
        if (string == null) {
            return null;
        }
        String qName = string;
        if (targetAnnotations.contains(qName)) {
            return annotation;
        }
        if (!visited.add(qName)) {
            return null;
        }
        if (StringsKt.startsWith$default((String)qName, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qName, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qName, (String)"javax.", (boolean)false, (int)2, null)) {
            return null;
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
        PsiElement psiElement = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return null;
        }
        PsiClass annotationClass = psiClass;
        for (PsiAnnotation metaAnnotation : annotationClass.getAnnotations()) {
            Intrinsics.checkNotNull((Object)metaAnnotation);
            PsiAnnotation found = this.findRecursively(metaAnnotation, visited, targetAnnotations);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public final boolean hasAnnotations(@NotNull PsiClass psiClass, @NotNull Collection<String> targetAnnotations, boolean findAll) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter(targetAnnotations, (String)"targetAnnotations");
        for (PsiClass currentClass = psiClass; currentClass != null && !Intrinsics.areEqual((Object)currentClass.getQualifiedName(), (Object)"java.lang.Object"); currentClass = currentClass.getSuperClass()) {
            if (!this.hasTargetAnnotation((PsiModifierListOwner)currentClass, targetAnnotations, findAll)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean hasAnnotations$default(AnnotationResolver annotationResolver, PsiClass psiClass, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return annotationResolver.hasAnnotations(psiClass, collection, bl);
    }

    @Nullable
    public final PsiAnnotation findAnnotationInHierarchy(@Nullable PsiModifierListOwner psiClassOrMethod, @NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        if (psiClassOrMethod == null) {
            return null;
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)psiClassOrMethod, (Set)SetsKt.setOf((Object)fqn));
    }

    private final boolean hasTargetAnnotation(PsiModifierListOwner owner, Collection<String> targetAnnotations, boolean findAll) {
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            Intrinsics.checkNotNull((Object)annotation);
            if (!AnnotationResolver.isMetaAnnotated$default(this, annotation, new LinkedHashSet(), targetAnnotations, findAll, null, 16, null)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean hasTargetAnnotation$default(AnnotationResolver annotationResolver, PsiModifierListOwner psiModifierListOwner, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return annotationResolver.hasTargetAnnotation(psiModifierListOwner, collection, bl);
    }

    @Nullable
    public final PsiMethod findMethodWithMapping(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.hasSpringMapping(method)) {
            return method;
        }
        for (PsiMethod superMethod : method.findSuperMethods()) {
            Intrinsics.checkNotNull((Object)superMethod);
            PsiMethod found = this.findMethodWithMapping(superMethod);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public final boolean isMappingMethod(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.hasSpringMapping(method)) {
            return true;
        }
        for (PsiMethod superMethod : method.findSuperMethods(true)) {
            Intrinsics.checkNotNull((Object)superMethod);
            if (!this.hasSpringMapping(superMethod)) continue;
            return true;
        }
        return false;
    }

    private final boolean hasSpringMapping(PsiMethod method) {
        for (String annoName : SpringClassName.INSTANCE.getSPRING_SINGLE_REQUEST_MAPPING_ANNOTATIONS()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (String)annoName, (int)0)) continue;
            return true;
        }
        return false;
    }

    private final boolean isMetaAnnotated(PsiAnnotation annotation, Set<String> visited, Collection<String> targetAnnotations, boolean findAll, Set<String> foundSoFar) {
        String string = annotation.getQualifiedName();
        if (string == null) {
            return false;
        }
        String qName = string;
        if (targetAnnotations.contains(qName)) {
            foundSoFar.add(qName);
        }
        if (findAll ? foundSoFar.containsAll(targetAnnotations) : !((Collection)foundSoFar).isEmpty()) {
            return true;
        }
        if (!visited.add(qName)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)qName, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qName, (String)"kotlin.", (boolean)false, (int)2, null)) {
            return false;
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
        PsiElement psiElement = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return false;
        }
        PsiClass annotationClass = psiClass;
        for (PsiAnnotation metaAnnotation : annotationClass.getAnnotations()) {
            Intrinsics.checkNotNull((Object)metaAnnotation);
            if (!this.isMetaAnnotated(metaAnnotation, visited, targetAnnotations, findAll, foundSoFar)) continue;
            return true;
        }
        return findAll && foundSoFar.containsAll(targetAnnotations);
    }

    static /* synthetic */ boolean isMetaAnnotated$default(AnnotationResolver annotationResolver, PsiAnnotation psiAnnotation, Set set, Collection collection, boolean bl, Set set2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            set2 = new LinkedHashSet();
        }
        return annotationResolver.isMetaAnnotated(psiAnnotation, set, collection, bl, set2);
    }

    private final String generateNotEqualValue(String original) {
        if (((CharSequence)original).length() == 0) {
            return "not_empty";
        }
        char[] cArray = original.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        int lastIndex = ArraysKt.getLastIndex((char[])chars);
        char lastChar = chars[lastIndex];
        chars[lastIndex] = lastChar > '!' ? (char)(lastChar - '\u0001') : (char)(lastChar + '\u0001');
        return new String(chars);
    }

    private static final void getAnnotationAttributeValues$extract(List<String> result, PsiElement element) {
        Object computed;
        PsiElement psiElement = element;
        if (psiElement instanceof PsiLiteralExpression) {
            String text;
            Object object = ((PsiLiteralExpression)element).getValue();
            String string = text = object instanceof String ? (String)object : null;
            if (text != null) {
                result.add(text);
            }
        } else if (psiElement instanceof PsiReferenceExpression) {
            PsiElement resolve = ((PsiReferenceExpression)element).resolve();
            if (resolve instanceof PsiField) {
                String constantVal;
                Object object = ((PsiField)resolve).computeConstantValue();
                String string = constantVal = object instanceof String ? (String)object : null;
                if (constantVal != null) {
                    result.add(constantVal);
                }
            }
        } else if (psiElement instanceof PsiBinaryExpression) {
            try {
                Object computed2 = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)element), (boolean)false);
                if (computed2 != null && computed2 instanceof String) {
                    result.add((String)computed2);
                }
            }
            catch (Exception computed2) {}
        } else if (psiElement instanceof PsiExpression && (computed = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)element), (boolean)false)) instanceof String) {
            result.add((String)computed);
        }
    }
}

