/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.lifecycle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.sheldon.idea.plugin.api.model.ApiMockRequest;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.utils.GlobalObjectStorageService;
import com.sheldon.idea.plugin.api.utils.MockGenerator;
import com.sheldon.idea.plugin.api.utils.ProjectCacheService;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/lifecycle/AfterBuildRequest;", "", "request", "Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "<init>", "(Lcom/sheldon/idea/plugin/api/model/ApiRequest;)V", "getRequest", "()Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "saveMock", "", "prefix", "hasDocs", "idea-plugin"})
public final class AfterBuildRequest {
    @NotNull
    private final ApiRequest request;

    public AfterBuildRequest(@NotNull ApiRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
    }

    @NotNull
    public final ApiRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final String execute(@NotNull Project project, @NotNull Module module, boolean saveMock, @NotNull String prefix, boolean hasDocs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (!hasDocs) {
            String string;
            ProjectCacheService cacheService = ProjectCacheService.Companion.getInstance(project);
            String string2 = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String requestKey = cacheService.saveOrUpdateSingleRequest(string2, this.request);
            CharSequence charSequence = requestKey;
            if (!(charSequence == null || charSequence.length() == 0)) {
                if (saveMock) {
                    ApiMockRequest mockData = MockGenerator.generate$default(new MockGenerator(module), this.request, prefix, null, 4, null);
                    String string3 = module.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    cacheService.saveOrUpdateSingleRequestMock(string3, requestKey, mockData);
                }
                String string4 = module.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                cacheService.addReferToMethodPathPool(string4, requestKey);
            }
            if ((string = requestKey) == null) {
                string = "";
            }
            return string;
        }
        GlobalObjectStorageService cacheService = (GlobalObjectStorageService)ApplicationManager.getApplication().getService(GlobalObjectStorageService.class);
        String string = this.request.getMethod();
        Intrinsics.checkNotNull((Object)string);
        String string5 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        String key = string5 + ":" + this.request.getPath();
        cacheService.save(key, this.request);
        return "";
    }

    public static /* synthetic */ String execute$default(AfterBuildRequest afterBuildRequest, Project project, Module module, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string = "";
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return afterBuildRequest.execute(project, module, bl, string, bl2);
    }
}

