/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.docs.extractor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.sheldon.idea.plugin.api.model.CodeType;
import com.sheldon.idea.plugin.api.utils.build.docs.DocExtractor;
import com.sheldon.idea.plugin.api.utils.build.docs.DocInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.ExtractionContext;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiImplicitParamInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiImplicitParamParser;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiModelInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiModelParser;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiModelPropertyInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiModelPropertyParser;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiOperationInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiOperationParser;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiParamInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiParamParser;
import com.sheldon.idea.plugin.api.utils.build.docs.utils.ApiParser;
import com.sheldon.idea.plugin.api.utils.build.resolver.AnnotationResolver;
import com.sheldon.idea.plugin.api.utils.build.resolver.AnnotationResolverKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J@\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002J,\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006)"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/docs/extractor/SwaggerExtractor;", "Lcom/sheldon/idea/plugin/api/utils/build/docs/DocExtractor;", "<init>", "()V", "getOrder", "", "extract", "", "context", "Lcom/sheldon/idea/plugin/api/utils/build/docs/ExtractionContext;", "currentDoc", "Lcom/sheldon/idea/plugin/api/utils/build/docs/DocInfo;", "codeType", "Lcom/sheldon/idea/plugin/api/model/CodeType;", "hasDocs", "", "handleApi", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "handleApiOperation", "Lkotlin/Pair;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "paramMetadata", "", "handleApiModel", "handleApiModelProperty", "Lcom/intellij/psi/PsiField;", "handleApiParam", "Lcom/intellij/psi/PsiParameter;", "getAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "element", "Lcom/intellij/psi/PsiElement;", "fqn", "isClass", "isMethod", "isParam", "isPojoClass", "isPojoField", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nSwaggerExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerExtractor.kt\ncom/sheldon/idea/plugin/api/utils/build/docs/extractor/SwaggerExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1863#2,2:153\n1863#2,2:155\n*S KotlinDebug\n*F\n+ 1 SwaggerExtractor.kt\ncom/sheldon/idea/plugin/api/utils/build/docs/extractor/SwaggerExtractor\n*L\n76#1:153,2\n79#1:155,2\n*E\n"})
public final class SwaggerExtractor
implements DocExtractor {
    @Override
    public int getOrder() {
        return 20;
    }

    @Override
    public void extract(@NotNull ExtractionContext context, @NotNull DocInfo currentDoc, @NotNull CodeType codeType, boolean hasDocs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)currentDoc, (String)"currentDoc");
        Intrinsics.checkNotNullParameter((Object)codeType, (String)"codeType");
        PsiElement element = context.getTargetElement();
        Map<String, DocInfo> paramMetadata = context.getParamMetadata();
        String swaggerTitle = null;
        String swaggerDesc = null;
        if (this.isClass(codeType, element)) {
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClass");
            swaggerTitle = this.handleApi((PsiClass)element, currentDoc, hasDocs);
        } else if (this.isMethod(codeType, element)) {
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethod");
            Pair<String, String> pair = this.handleApiOperation((PsiMethod)element, currentDoc, hasDocs, paramMetadata);
            String title = (String)pair.component1();
            String desc = (String)pair.component2();
            swaggerTitle = title;
            swaggerDesc = desc;
        } else if (this.isPojoClass(codeType, element)) {
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClass");
            Pair<String, String> pair = this.handleApiModel((PsiClass)element, currentDoc, hasDocs);
            String title = (String)pair.component1();
            String desc = (String)pair.component2();
            swaggerTitle = title;
            swaggerDesc = desc;
        } else if (this.isPojoField(codeType, element)) {
            String title;
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.psi.PsiField");
            swaggerTitle = title = (String)this.handleApiModelProperty((PsiField)element, currentDoc, hasDocs).component1();
        } else if (this.isParam(codeType, element)) {
            String title;
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.psi.PsiParameter");
            swaggerTitle = title = (String)this.handleApiParam((PsiParameter)element, currentDoc, hasDocs).component1();
        }
        currentDoc.merge(swaggerTitle, swaggerDesc);
    }

    private final String handleApi(PsiClass psiClass, DocInfo currentDoc, boolean hasDocs) {
        PsiAnnotation psiAnnotation = this.getAnnotation((PsiElement)psiClass, "io.swagger.annotations.Api");
        if (psiAnnotation == null) {
            return "";
        }
        PsiAnnotation annotation = psiAnnotation;
        ApiInfo apiInfo = ApiParser.INSTANCE.parse(annotation);
        if (((CharSequence)apiInfo.getValue()).length() == 0) {
            apiInfo.setValue(String.valueOf(psiClass.getQualifiedName()));
        }
        if (hasDocs) {
            String string = psiClass.getQualifiedName();
            if (string == null) {
                string = "";
            }
            apiInfo.setQualifiedName(string);
            currentDoc.setApiInfo(apiInfo);
        }
        return (String)CollectionsKt.first(apiInfo.getTags());
    }

    private final Pair<String, String> handleApiOperation(PsiMethod psiMethod, DocInfo currentDoc, boolean hasDocs, Map<String, DocInfo> paramMetadata) {
        ApiImplicitParamInfo paramData;
        PsiAnnotation psiAnnotation = this.getAnnotation((PsiElement)psiMethod, "io.swagger.annotations.ApiOperation");
        if (psiAnnotation == null) {
            return new Pair((Object)"", (Object)"");
        }
        PsiAnnotation annotation = psiAnnotation;
        ApiOperationInfo apiOperationInfo = ApiOperationParser.INSTANCE.parse(annotation);
        PsiAnnotation paramAnnotation = this.getAnnotation((PsiElement)psiMethod, "io.swagger.annotations.ApiImplicitParam");
        List<ApiImplicitParamInfo> paramDataList = ApiImplicitParamParser.INSTANCE.parse(paramAnnotation);
        PsiAnnotation paramAnnotations = this.getAnnotation((PsiElement)psiMethod, "io.swagger.annotations.ApiImplicitParams");
        List<ApiImplicitParamInfo> paramsDataList = ApiImplicitParamParser.INSTANCE.parse(paramAnnotations);
        Iterable $this$forEach$iv = paramDataList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            paramData = (ApiImplicitParamInfo)element$iv;
            boolean bl = false;
            paramMetadata.put(paramData.getName(), new DocInfo(null, null, null, null, paramData, null, null, null, 239, null));
        }
        $this$forEach$iv = paramsDataList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            paramData = (ApiImplicitParamInfo)element$iv;
            boolean bl = false;
            paramMetadata.put(paramData.getName(), new DocInfo(null, null, null, null, paramData, null, null, null, 239, null));
        }
        if (hasDocs) {
            currentDoc.setApiOperationInfo(apiOperationInfo);
        }
        return new Pair((Object)apiOperationInfo.getTitle(), (Object)apiOperationInfo.getDesc());
    }

    private final Pair<String, String> handleApiModel(PsiClass psiMethod, DocInfo currentDoc, boolean hasDocs) {
        PsiAnnotation psiAnnotation = this.getAnnotation((PsiElement)psiMethod, "io.swagger.annotations.ApiModel");
        if (psiAnnotation == null) {
            return new Pair((Object)"", (Object)"");
        }
        PsiAnnotation annotation = psiAnnotation;
        ApiModelInfo apiModelInfo = ApiModelParser.INSTANCE.parse(annotation);
        if (hasDocs) {
            currentDoc.setApiModelInfo(apiModelInfo);
        }
        return new Pair((Object)apiModelInfo.getName(), (Object)apiModelInfo.getDescription());
    }

    private final Pair<String, String> handleApiModelProperty(PsiField psiMethod, DocInfo currentDoc, boolean hasDocs) {
        PsiAnnotation psiAnnotation = this.getAnnotation((PsiElement)psiMethod, "io.swagger.annotations.ApiModelProperty");
        if (psiAnnotation == null) {
            return new Pair((Object)"", (Object)"");
        }
        PsiAnnotation annotation = psiAnnotation;
        ApiModelPropertyInfo apiModelPropertyInfo = ApiModelPropertyParser.INSTANCE.parse(annotation);
        if (hasDocs) {
            currentDoc.setApiApiModelPropertyInfo(apiModelPropertyInfo);
        }
        return new Pair((Object)apiModelPropertyInfo.getTitle(), (Object)"");
    }

    private final Pair<String, String> handleApiParam(PsiParameter psiMethod, DocInfo currentDoc, boolean hasDocs) {
        PsiAnnotation psiAnnotation = this.getAnnotation((PsiElement)psiMethod, "io.swagger.annotations.ApiParam");
        if (psiAnnotation == null) {
            return new Pair((Object)"", (Object)"");
        }
        PsiAnnotation annotation = psiAnnotation;
        ApiParamInfo apiParamInfo = ApiParamParser.INSTANCE.parse(annotation);
        if (hasDocs) {
            currentDoc.setApiParamInfo(apiParamInfo);
        }
        return new Pair((Object)apiParamInfo.getName(), (Object)"");
    }

    private final PsiAnnotation getAnnotation(PsiElement element, String fqn) {
        if (element instanceof PsiClass || element instanceof PsiMethod) {
            return AnnotationResolver.INSTANCE.findAnnotationInHierarchy((PsiModifierListOwner)element, fqn);
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getAnnotation(fqn);
        }
        if (element instanceof PsiParameter) {
            return AnnotationResolverKt.findAnnotationInHierarchy((PsiParameter)element, fqn);
        }
        return null;
    }

    private final boolean isClass(CodeType codeType, PsiElement element) {
        return codeType == CodeType.CLASS && element instanceof PsiClass;
    }

    private final boolean isMethod(CodeType codeType, PsiElement element) {
        return codeType == CodeType.METHOD && element instanceof PsiMethod;
    }

    private final boolean isParam(CodeType codeType, PsiElement element) {
        return codeType == CodeType.PARAM && element instanceof PsiParameter;
    }

    private final boolean isPojoClass(CodeType codeType, PsiElement element) {
        return codeType == CodeType.POJO_CLASS && element instanceof PsiClass;
    }

    private final boolean isPojoField(CodeType codeType, PsiElement element) {
        return codeType == CodeType.POJO_FIELD && element instanceof PsiField;
    }
}

