/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.docs.extractor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.sheldon.idea.plugin.api.model.CodeType;
import com.sheldon.idea.plugin.api.utils.build.docs.DocExtractor;
import com.sheldon.idea.plugin.api.utils.build.docs.DocInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.ExtractionContext;
import com.sheldon.idea.plugin.api.utils.build.resolver.ResolverHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/docs/extractor/JavadocExtractor;", "Lcom/sheldon/idea/plugin/api/utils/build/docs/DocExtractor;", "<init>", "()V", "getOrder", "", "extract", "", "context", "Lcom/sheldon/idea/plugin/api/utils/build/docs/ExtractionContext;", "currentDoc", "Lcom/sheldon/idea/plugin/api/utils/build/docs/DocInfo;", "codeType", "Lcom/sheldon/idea/plugin/api/model/CodeType;", "hasDocs", "", "parseJavadoc", "Lkotlin/Pair;", "", "element", "Lcom/intellij/psi/PsiElement;", "getFieldComment", "getElementComment", "normalizeJavadoc", "text", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nJavadocExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavadocExtractor.kt\ncom/sheldon/idea/plugin/api/utils/build/docs/extractor/JavadocExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,107:1\n1557#2:108\n1628#2,3:109\n774#2:112\n865#2,2:113\n1557#2:118\n1628#2,3:119\n774#2:122\n865#2,2:123\n1104#3,3:115\n*S KotlinDebug\n*F\n+ 1 JavadocExtractor.kt\ncom/sheldon/idea/plugin/api/utils/build/docs/extractor/JavadocExtractor\n*L\n43#1:108\n43#1:109,3\n44#1:112\n44#1:113,2\n85#1:118\n85#1:119,3\n85#1:122\n85#1:123,2\n67#1:115,3\n*E\n"})
public final class JavadocExtractor
implements DocExtractor {
    @Override
    public int getOrder() {
        return 10;
    }

    @Override
    public void extract(@NotNull ExtractionContext context, @NotNull DocInfo currentDoc, @NotNull CodeType codeType, boolean hasDocs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)currentDoc, (String)"currentDoc");
        Intrinsics.checkNotNullParameter((Object)codeType, (String)"codeType");
        PsiElement element = context.getTargetElement();
        Pair<String, String> pair = this.parseJavadoc(element, codeType);
        String javaDocTitle = (String)pair.component1();
        String javaDocDesc = (String)pair.component2();
        if (((CharSequence)javaDocTitle).length() > 0) {
            currentDoc.merge(javaDocTitle, javaDocDesc);
        }
    }

    private final Pair<String, String> parseJavadoc(PsiElement element, CodeType codeType) {
        if (codeType == CodeType.PARAM) {
            return new Pair((Object)this.getFieldComment(element), (Object)"");
        }
        return this.getElementComment(element);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFieldComment(@Nullable PsiElement element) {
        if (element == null) {
            return "";
        }
        List comments = new ArrayList();
        if (element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).getDocComment() != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            PsiDocComment psiDocComment = ((PsiDocCommentOwner)element).getDocComment();
            Intrinsics.checkNotNull((Object)psiDocComment);
            Object object = psiDocComment.getDescriptionElements();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDescriptionElements(...)");
            String rawText = ArraysKt.joinToString$default((Object[])object, (CharSequence)"", null, null, (int)0, null, JavadocExtractor::getFieldComment$lambda$0, (int)30, null);
            object = StringsKt.lines((CharSequence)this.normalizeJavadoc(rawText));
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement $this$filter$iv = child;
            if ($this$filter$iv instanceof PsiComment) {
                String string = ((PsiComment)child).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                comments.add(ResolverHelper.Companion.cleanComment(string));
                continue;
            }
            if (!($this$filter$iv instanceof PsiWhiteSpace)) break;
        }
        if (!((Collection)comments).isEmpty()) {
            return CollectionsKt.joinToString$default((Iterable)comments, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        PsiElement prev = element.getPrevSibling();
        int safetyCount = 0;
        while (prev != null && safetyCount < 20) {
            if (prev instanceof PsiComment) {
                String string = ((PsiComment)prev).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                comments.add(0, ResolverHelper.Companion.cleanComment(string));
            } else if (prev instanceof PsiWhiteSpace) {
                String string = ((PsiWhiteSpace)prev).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                CharSequence $this$count$iv = string;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                if (count$iv > 1) {
                    break;
                }
            } else {
                if (!(prev instanceof PsiAnnotation)) break;
                continue;
            }
            prev = prev.getPrevSibling();
            ++safetyCount;
        }
        return CollectionsKt.joinToString$default((Iterable)comments, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String, String> getElementComment(@NotNull PsiElement element) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PsiDocCommentOwner)) {
            return TuplesKt.to((Object)"", (Object)"");
        }
        PsiDocComment psiDocComment = ((PsiDocCommentOwner)element).getDocComment();
        if (psiDocComment == null) {
            return TuplesKt.to((Object)"", (Object)"");
        }
        PsiDocComment docComment = psiDocComment;
        PsiElement[] psiElementArray = docComment.getDescriptionElements();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getDescriptionElements(...)");
        String rawText = ArraysKt.joinToString$default((Object[])psiElementArray, (CharSequence)"", null, null, (int)0, null, JavadocExtractor::getElementComment$lambda$4, (int)30, null);
        String cleanText = this.normalizeJavadoc(rawText);
        Iterable $this$map$iv = StringsKt.lines((CharSequence)cleanText);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validLines = (List)destination$iv$iv;
        String alias = CollectionsKt.firstOrNull((List)validLines) == null ? "" : (String)CollectionsKt.first((List)validLines);
        String desc = validLines.size() > 1 ? CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)validLines, (int)1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : "";
        return TuplesKt.to((Object)alias, (Object)desc);
    }

    private final String normalizeJavadoc(String text) {
        String result = text;
        CharSequence charSequence = result;
        Regex regex = new Regex("(?m)^[\\s]*\\*+");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("^/\\*+");
        string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\\*+/$");
        string = "";
        result = regex.replace(charSequence, string);
        charSequence = result;
        regex = new Regex("(?i)</?(p|br|div|li|ul|h\\d)[^>]*>");
        string = "\n";
        result = regex.replace(charSequence, string);
        charSequence = result;
        regex = new Regex("<[^>]+>");
        string = "";
        result = regex.replace(charSequence, string);
        charSequence = result;
        regex = new Regex("\\{@\\w+\\s+(.*?)\\}");
        string = "$1";
        result = regex.replace(charSequence, string);
        result = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)result, (String)"&nbsp;", (String)" ", (boolean)false, (int)4, null), (String)"&lt;", (String)"<", (boolean)false, (int)4, null), (String)"&gt;", (String)">", (boolean)false, (int)4, null), (String)"&amp;", (String)"&", (boolean)false, (int)4, null), (String)"&quot;", (String)"\"", (boolean)false, (int)4, null);
        return result;
    }

    private static final CharSequence getFieldComment$lambda$0(PsiElement it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final CharSequence getElementComment$lambda$4(PsiElement it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

