/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.sheldon.idea.plugin.api.method.AsyncTestVariableNode;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.model.DataStructure;
import com.sheldon.idea.plugin.api.utils.GlobalObjectStorageService;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t\u001a\u0012\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0003\u00a8\u0006\u000e"}, d2={"resolveHttpMethod", "Lio/swagger/v3/oas/models/PathItem$HttpMethod;", "method", "", "getRequest", "Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "methodNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "getDsNode", "Lcom/sheldon/idea/plugin/api/method/AsyncTestVariableNode;", "node", "buildSchemaByAsyncType", "Lio/swagger/v3/oas/models/media/Schema;", "type", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nResolverHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolverHelper.kt\ncom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/utils/ResolverHelperKt\n+ 2 GlobalObjectStorageService.kt\ncom/sheldon/idea/plugin/api/utils/GlobalObjectStorageService\n*L\n1#1,61:1\n17#2:62\n17#2:63\n*S KotlinDebug\n*F\n+ 1 ResolverHelper.kt\ncom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/utils/ResolverHelperKt\n*L\n28#1:62\n32#1:63\n*E\n"})
public final class ResolverHelperKt {
    @Nullable
    public static final PathItem.HttpMethod resolveHttpMethod(@Nullable String method) {
        CharSequence charSequence = method;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        String string = ((Object)StringsKt.trim((CharSequence)method)).toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return switch (string) {
            case "GET" -> PathItem.HttpMethod.GET;
            case "POST" -> PathItem.HttpMethod.POST;
            case "PUT" -> PathItem.HttpMethod.PUT;
            case "DELETE" -> PathItem.HttpMethod.DELETE;
            case "PATCH" -> PathItem.HttpMethod.PATCH;
            case "HEAD" -> PathItem.HttpMethod.HEAD;
            case "OPTIONS" -> PathItem.HttpMethod.OPTIONS;
            case "TRACE" -> PathItem.HttpMethod.TRACE;
            default -> null;
        };
    }

    @Nullable
    public static final ApiRequest getRequest(@NotNull ApiNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        GlobalObjectStorageService cacheService = (GlobalObjectStorageService)ApplicationManager.getApplication().getService(GlobalObjectStorageService.class);
        String string = methodNode.getMethod();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String key = string2 + ":" + methodNode.getPath();
        GlobalObjectStorageService this_$iv = cacheService;
        boolean $i$f$get = false;
        Object object = this_$iv.getRaw(key);
        if (!(object instanceof ApiRequest)) {
            object = null;
        }
        return (ApiRequest)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final AsyncTestVariableNode getDsNode(@NotNull AsyncTestVariableNode node) {
        DataStructure dataStructure;
        void this_$iv;
        GlobalObjectStorageService cacheService;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        GlobalObjectStorageService globalObjectStorageService = cacheService = (GlobalObjectStorageService)ApplicationManager.getApplication().getService(GlobalObjectStorageService.class);
        String string = node.getDsTarget();
        if (string == null) {
            string = "";
        }
        String key$iv = string;
        boolean $i$f$get = false;
        Object object = this_$iv.getRaw(key$iv);
        if (!(object instanceof DataStructure)) {
            object = null;
        }
        if ((dataStructure = (DataStructure)object) != null && !((Collection)dataStructure.getData()).isEmpty()) {
            return (AsyncTestVariableNode)CollectionsKt.first((List)dataStructure.getData());
        }
        return null;
    }

    @NotNull
    public static final Schema<?> buildSchemaByAsyncType(@NotNull String type2) {
        Schema schema;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        switch (type2) {
            case "string": {
                schema = (Schema)new StringSchema();
                break;
            }
            case "integer": {
                schema = (Schema)new IntegerSchema();
                break;
            }
            case "number": {
                schema = (Schema)new NumberSchema();
                break;
            }
            case "boolean": {
                schema = (Schema)new BooleanSchema();
                break;
            }
            case "array": {
                schema = (Schema)new ArraySchema();
                break;
            }
            case "object": {
                schema = (Schema)new ObjectSchema();
                break;
            }
            case "files": {
                Schema schema2 = new StringSchema().format("binary");
                schema = schema2;
                Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"format(...)");
                break;
            }
            case "null": {
                Schema schema3 = new Schema().nullable(Boolean.valueOf(true));
                schema = schema3;
                Intrinsics.checkNotNullExpressionValue((Object)schema3, (String)"nullable(...)");
                break;
            }
            case "ds": {
                schema = new Schema();
                break;
            }
            default: {
                schema = new Schema();
            }
        }
        return schema;
    }
}

