/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\tJ0\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\tJ<\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/utils/ExportHelper;", "", "<init>", "()V", "exportJsonToFile", "", "project", "Lcom/intellij/openapi/project/Project;", "jsonContent", "", "defaultFileName", "extensions", "title", "exportBinaryToFile", "data", "", "saveFile", "writeAction", "Lkotlin/Function1;", "Ljava/io/File;", "", "idea-plugin"})
public final class ExportHelper {
    @NotNull
    public static final ExportHelper INSTANCE = new ExportHelper();

    private ExportHelper() {
    }

    public final boolean exportJsonToFile(@NotNull Project project, @NotNull String jsonContent, @NotNull String defaultFileName, @NotNull String extensions, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)defaultFileName, (String)"defaultFileName");
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return this.saveFile(project, defaultFileName, extensions, title, (Function1<? super File, Unit>)((Function1)arg_0 -> ExportHelper.exportJsonToFile$lambda$0(jsonContent, arg_0)));
    }

    public static /* synthetic */ boolean exportJsonToFile$default(ExportHelper exportHelper, Project project, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "openapi.json";
        }
        if ((n & 8) != 0) {
            string3 = "json";
        }
        if ((n & 0x10) != 0) {
            string4 = "\u4fdd\u5b58 JSON \u6587\u6863";
        }
        return exportHelper.exportJsonToFile(project, string, string2, string3, string4);
    }

    public final boolean exportBinaryToFile(@NotNull Project project, @NotNull byte[] data, @NotNull String defaultFileName, @NotNull String extensions, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)defaultFileName, (String)"defaultFileName");
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return this.saveFile(project, defaultFileName, extensions, title, (Function1<? super File, Unit>)((Function1)arg_0 -> ExportHelper.exportBinaryToFile$lambda$1(data, arg_0)));
    }

    public static /* synthetic */ boolean exportBinaryToFile$default(ExportHelper exportHelper, Project project, byte[] byArray, String string, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = "\u4fdd\u5b58\u6587\u4ef6";
        }
        return exportHelper.exportBinaryToFile(project, byArray, string, string2, string3);
    }

    private final boolean saveFile(Project project, String defaultFileName, String extensions, String title, Function1<? super File, Unit> writeAction) {
        FileSaverDescriptor fileSaverDescriptor;
        if (((CharSequence)extensions).length() > 0) {
            String[] stringArray = new String[]{extensions};
            FileSaverDescriptor fileSaverDescriptor2 = new FileSaverDescriptor(title, "\u9009\u62e9\u4fdd\u5b58\u4f4d\u7f6e", stringArray);
            fileSaverDescriptor = fileSaverDescriptor2;
        } else {
            fileSaverDescriptor = new FileSaverDescriptor(title, "\u9009\u62e9\u4fdd\u5b58\u4f4d\u7f6e", new String[0]);
        }
        FileSaverDescriptor descriptor = fileSaverDescriptor;
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog saveFileDialog = fileSaverDialog;
        VirtualFileWrapper virtualFileWrapper = saveFileDialog.save(null, defaultFileName);
        if (virtualFileWrapper == null) {
            return false;
        }
        VirtualFileWrapper fileWrapper = virtualFileWrapper;
        Ref.ObjectRef file = new Ref.ObjectRef();
        File file2 = fileWrapper.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getFile(...)");
        file.element = file2;
        if (((CharSequence)extensions).length() > 0) {
            String string = ((File)file.element).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith((String)string, (String)("." + extensions), (boolean)true)) {
                file.element = new File(((File)file.element).getParentFile(), ((File)file.element).getName() + "." + extensions);
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> ExportHelper.saveFile$lambda$2(writeAction, file));
        return true;
    }

    private static final Unit exportJsonToFile$lambda$0(String $jsonContent, File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilesKt.writeText$default((File)file, (String)$jsonContent, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit exportBinaryToFile$lambda$1(byte[] $data, File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilesKt.writeBytes((File)file, (byte[])$data);
        return Unit.INSTANCE;
    }

    private static final void saveFile$lambda$2(Function1 $writeAction, Ref.ObjectRef $file) {
        try {
            $writeAction.invoke($file.element);
            LocalFileSystem.getInstance().refreshAndFindFileByIoFile((File)$file.element);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

