/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.resolver;

import com.sheldon.idea.plugin.api.method.AsyncTestVariableNode;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.OpenApiBuildContext;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.parser.SchemaParser;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.utils.ResolverHelperKt;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/resolver/TypeResolver;", "", "<init>", "()V", "resolveSchema", "Lio/swagger/v3/oas/models/media/Schema;", "node", "Lcom/sheldon/idea/plugin/api/method/AsyncTestVariableNode;", "context", "Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/OpenApiBuildContext;", "resolveObjectSchema", "idea-plugin"})
public final class TypeResolver {
    @NotNull
    public static final TypeResolver INSTANCE = new TypeResolver();

    private TypeResolver() {
    }

    @NotNull
    public final Schema<?> resolveSchema(@NotNull AsyncTestVariableNode node, @NotNull OpenApiBuildContext context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Schema<?> schemaType = ResolverHelperKt.buildSchemaByAsyncType(node.getType());
        Object[] objectArray = new String[]{"ds", "null", "array", "object"};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(node.getType())) {
            schemaType.description(node.getStatement());
            return schemaType;
        }
        if (Intrinsics.areEqual((Object)node.getType(), (Object)"ds")) {
            return this.resolveObjectSchema(node, context);
        }
        if (Intrinsics.areEqual((Object)node.getType(), (Object)"object")) {
            Schema schema = new ObjectSchema().items(this.resolveSchema((AsyncTestVariableNode)CollectionsKt.first((List)node.getChildren()), context));
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"items(...)");
            return schema;
        }
        if (Intrinsics.areEqual((Object)node.getType(), (Object)"array")) {
            ArraySchema arraySchema = new ArraySchema().items(this.resolveSchema((AsyncTestVariableNode)CollectionsKt.first((List)node.getChildren()), context));
            Intrinsics.checkNotNullExpressionValue((Object)arraySchema, (String)"items(...)");
            return (Schema)arraySchema;
        }
        return (Schema)new StringSchema();
    }

    private final Schema<?> resolveObjectSchema(AsyncTestVariableNode node, OpenApiBuildContext context) {
        if (!CollectionsKt.contains((Iterable)context.getRegisteredSchemas(), (Object)node.getDsTarget())) {
            Schema<?> schema = new SchemaParser(context).parse(node);
            String string = node.getDsTarget();
            if (string == null) {
                string = "";
            }
            context.registerSchema(string, schema);
        }
        Schema schema = new Schema();
        String string = node.getDsTarget();
        if (string == null) {
            string = "";
        }
        Schema schema2 = schema.$ref("#/components/schemas/" + string);
        Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"$ref(...)");
        return schema2;
    }
}

