/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.parser;

import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.OpenApiBuildContext;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.parser.ParameterParser;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.parser.RequestBodyParser;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.parser.ResponseParser;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.resolver.MethodNodeResolver;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.utils.ResolverHelperKt;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.RequestBody;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/parser/OperationParser;", "", "context", "Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/OpenApiBuildContext;", "<init>", "(Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/OpenApiBuildContext;)V", "parameterParser", "Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/parser/ParameterParser;", "requestBodyParser", "Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/parser/RequestBodyParser;", "responseParser", "Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/parser/ResponseParser;", "attachOperation", "", "pathItem", "Lio/swagger/v3/oas/models/PathItem;", "httpMethod", "Lio/swagger/v3/oas/models/PathItem$HttpMethod;", "methodNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "tagName", "", "idea-plugin"})
public final class OperationParser {
    @NotNull
    private final OpenApiBuildContext context;
    @NotNull
    private final ParameterParser parameterParser;
    @NotNull
    private final RequestBodyParser requestBodyParser;
    @NotNull
    private final ResponseParser responseParser;

    public OperationParser(@NotNull OpenApiBuildContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.parameterParser = new ParameterParser(this.context);
        this.requestBodyParser = new RequestBodyParser(this.context);
        this.responseParser = new ResponseParser(this.context);
    }

    public final void attachOperation(@NotNull PathItem pathItem, @NotNull PathItem.HttpMethod httpMethod, @NotNull ApiNode methodNode, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)pathItem, (String)"pathItem");
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Operation operation = new Operation();
        operation.addTagsItem(tagName);
        new MethodNodeResolver().registerMethod(methodNode, operation);
        ApiRequest request = ResolverHelperKt.getRequest(methodNode);
        if (request != null) {
            this.parameterParser.parseQuery(methodNode, request.getQuery(), operation);
            this.parameterParser.parseHeader(methodNode, request.getHeaders(), operation);
            RequestBody requestBody = this.requestBodyParser.parse(methodNode, request);
            if (requestBody != null) {
                RequestBody it = requestBody;
                boolean bl = false;
                operation.requestBody(it);
            }
        }
        operation.responses(this.responseParser.parse(methodNode));
        switch (WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) {
            case 1: {
                Unit unit = pathItem.get(operation);
                break;
            }
            case 2: {
                Unit unit = pathItem.post(operation);
                break;
            }
            case 3: {
                Unit unit = pathItem.put(operation);
                break;
            }
            case 4: {
                Unit unit = pathItem.delete(operation);
                break;
            }
            case 5: {
                Unit unit = pathItem.patch(operation);
                break;
            }
            default: {
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathItem.HttpMethod.values().length];
            try {
                nArray[PathItem.HttpMethod.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathItem.HttpMethod.POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathItem.HttpMethod.PUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathItem.HttpMethod.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathItem.HttpMethod.PATCH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

