/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.parser;

import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.OpenApiBuildContext;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.parser.OperationParser;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.resolver.ClassNodeResolver;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.utils.ResolverHelperKt;
import io.swagger.v3.oas.models.PathItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/parser/ControllerParser;", "", "context", "Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/OpenApiBuildContext;", "<init>", "(Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/OpenApiBuildContext;)V", "operationParser", "Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/parser/OperationParser;", "parse", "", "classNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "parseMethod", "methodNode", "tagName", "", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nControllerParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControllerParser.kt\ncom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/parser/ControllerParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n1863#2,2:31\n*S KotlinDebug\n*F\n+ 1 ControllerParser.kt\ncom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/parser/ControllerParser\n*L\n13#1:31,2\n*E\n"})
public final class ControllerParser {
    @NotNull
    private final OpenApiBuildContext context;
    @NotNull
    private final OperationParser operationParser;

    public ControllerParser(@NotNull OpenApiBuildContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.operationParser = new OperationParser(this.context);
    }

    public final void parse(@NotNull ApiNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        String tagName = new ClassNodeResolver().registerController(classNode, this.context);
        Iterable $this$forEach$iv = classNode.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ApiNode method = (ApiNode)element$iv;
            boolean bl = false;
            this.parseMethod(method, tagName);
        }
    }

    private final void parseMethod(ApiNode methodNode, String tagName) {
        String string = methodNode.getPath();
        String fullPath = string != null ? StringsKt.replace$default((String)string, (String)"//", (String)"/", (boolean)false, (int)4, null) : null;
        PathItem pathItem = (PathItem)this.context.getOpenAPI().getPaths().getOrDefault((Object)fullPath, (Object)new PathItem());
        Intrinsics.checkNotNull((Object)pathItem);
        PathItem.HttpMethod httpMethod = ResolverHelperKt.resolveHttpMethod(methodNode.getMethod());
        if (httpMethod == null) {
            httpMethod = PathItem.HttpMethod.GET;
        }
        this.operationParser.attachOperation(pathItem, httpMethod, methodNode, tagName);
        this.context.getOpenAPI().getPaths().addPathItem(fullPath, pathItem);
    }
}

