/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/docs/export/openapi3/OpenApiBuildContext;", "", "<init>", "()V", "openAPI", "Lio/swagger/v3/oas/models/OpenAPI;", "getOpenAPI", "()Lio/swagger/v3/oas/models/OpenAPI;", "registeredSchemas", "", "", "getRegisteredSchemas", "()Ljava/util/Set;", "registerSchema", "", "name", "schema", "Lio/swagger/v3/oas/models/media/Schema;", "idea-plugin"})
public final class OpenApiBuildContext {
    @NotNull
    private final OpenAPI openAPI;
    @NotNull
    private final Set<String> registeredSchemas;

    public OpenApiBuildContext() {
        OpenAPI openAPI = new OpenAPI().components(new Components()).paths(new Paths());
        Intrinsics.checkNotNullExpressionValue((Object)openAPI, (String)"paths(...)");
        this.openAPI = openAPI;
        this.registeredSchemas = new LinkedHashSet();
    }

    @NotNull
    public final OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    @NotNull
    public final Set<String> getRegisteredSchemas() {
        return this.registeredSchemas;
    }

    public final void registerSchema(@NotNull String name, @NotNull Schema<?> schema) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        if (this.registeredSchemas.add(name)) {
            this.openAPI.getComponents().addSchemas(name, schema);
        }
    }
}

