/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.model.ChildNodeType;
import com.sheldon.idea.plugin.api.model.CodeType;
import com.sheldon.idea.plugin.api.model.NodeType;
import com.sheldon.idea.plugin.api.service.SpringClassName;
import com.sheldon.idea.plugin.api.utils.GlobalObjectStorageService;
import com.sheldon.idea.plugin.api.utils.HashUtilsKt;
import com.sheldon.idea.plugin.api.utils.PathUtils;
import com.sheldon.idea.plugin.api.utils.build.docs.DocInfo;
import com.sheldon.idea.plugin.api.utils.build.docs.DocResolver;
import com.sheldon.idea.plugin.api.utils.build.helper.ClassHelper;
import com.sheldon.idea.plugin.api.utils.build.helper.MethodHelper;
import com.sheldon.idea.plugin.api.utils.build.resolver.AnnotationResolver;
import com.sheldon.idea.plugin.api.utils.build.resolver.SpringClassResolver;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\bJL\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\b2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00130 J(\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\r\u00a8\u0006#"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/TreeBuilder;", "", "<init>", "()V", "findBasePackageDirectory", "Lcom/intellij/psi/PsiDirectory;", "dir", "isSpringBootApplicationClass", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "isController", "makeRootNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "module", "Lcom/intellij/openapi/module/Module;", "makeDirNode", "subDir", "parentPath", "", "makeClassNode", "classHelper", "Lcom/sheldon/idea/plugin/api/utils/build/helper/ClassHelper;", "hasDocs", "makeMethodNode", "methodHelper", "Lcom/sheldon/idea/plugin/api/utils/build/helper/MethodHelper;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "prefixPath", "classNode", "callback", "Lkotlin/Function2;", "Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "makeMethodExcludeParam", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nbase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 base.kt\ncom/sheldon/idea/plugin/api/utils/build/TreeBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,252:1\n12567#2,2:253\n*S KotlinDebug\n*F\n+ 1 base.kt\ncom/sheldon/idea/plugin/api/utils/build/TreeBuilder\n*L\n33#1:253,2\n*E\n"})
public abstract class TreeBuilder {
    @Nullable
    public final PsiDirectory findBasePackageDirectory(@NotNull PsiDirectory dir) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            PsiFile[] psiFileArray = dir.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
            Object[] $this$any$iv = psiFileArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                boolean bl2;
                block6: {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl3 = false;
                    if (it instanceof PsiJavaFile) {
                        for (PsiClass psiClass : ((PsiJavaFile)it).getClasses()) {
                            Intrinsics.checkNotNull((Object)psiClass);
                            if (!this.isSpringBootApplicationClass(psiClass)) continue;
                            bl2 = true;
                            break block6;
                        }
                        bl2 = false;
                    } else {
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return dir;
        }
        for (PsiDirectory sub : dir.getSubdirectories()) {
            PsiDirectory found;
            Intrinsics.checkNotNull((Object)sub);
            PsiDirectory psiDirectory = found = this.findBasePackageDirectory(sub);
            if (psiDirectory == null) continue;
            return psiDirectory;
        }
        return null;
    }

    public final boolean isSpringBootApplicationClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass), (String)"org.springframework.boot.autoconfigure.SpringBootApplication", (int)1)) {
            return true;
        }
        PsiAnnotation[] psiAnnotationArray = psiClass.getModifierList();
        if (psiAnnotationArray == null || (psiAnnotationArray = psiAnnotationArray.getAnnotations()) == null) {
            psiAnnotationArray = new PsiAnnotation[]{};
        }
        for (PsiAnnotation annotation : psiAnnotationArray) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
            Object object = resolved = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
            if (!(resolved instanceof PsiClass) || !AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)resolved), (String)"org.springframework.boot.autoconfigure.SpringBootApplication", (int)1)) continue;
            return true;
        }
        return false;
    }

    public final boolean isController(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (psiClass.getName() == null) {
            return false;
        }
        return AnnotationResolver.INSTANCE.hasAnnotations(psiClass, (Collection<String>)SpringClassName.INSTANCE.getSPRING_CONTROLLER_ANNOTATION(), false);
    }

    @NotNull
    public final ApiNode makeRootNode(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.ROOT_DIR.getCode();
        int n3 = CodeType.MODULE.getCode();
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        String string3 = module.getName() + "[" + CodeType.MODULE.getCode() + "]";
        return new ApiNode(n, n2, n3, 0, null, string2, "", "", string3, null, null, null, null, null, null, 32280, null);
    }

    @NotNull
    public final ApiNode makeDirNode(@NotNull PsiDirectory subDir, @NotNull String parentPath) {
        Intrinsics.checkNotNullParameter((Object)subDir, (String)"subDir");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.DIR.getCode();
        int n3 = CodeType.DIR.getCode();
        String string = subDir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        String string3 = parentPath + "[" + CodeType.DIR.getCode() + "]";
        return new ApiNode(n, n2, n3, 0, null, string2, "", "", string3, null, null, null, null, null, null, 32280, null);
    }

    @NotNull
    public final ApiNode makeClassNode(@NotNull ClassHelper classHelper, @NotNull PsiClass psiClass, @NotNull String parentPath, boolean hasDocs) {
        Intrinsics.checkNotNullParameter((Object)classHelper, (String)"classHelper");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        DocInfo docInfo = (DocInfo)new DocResolver().resolve((PsiElement)psiClass, new LinkedHashMap(), CodeType.CLASS, hasDocs).component1();
        ApiRequest request = new SpringClassResolver().resolveRequestMapping(psiClass);
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.DIR.getCode();
        int n3 = CodeType.CLASS.getCode();
        String string = psiClass.getName();
        if (string == null) {
            string = "";
        }
        String string2 = string;
        String string3 = docInfo.getTitle();
        String string4 = docInfo.getDescription();
        ApiRequest apiRequest = request;
        String string5 = apiRequest != null ? apiRequest.getPath() : null;
        ApiNode result = new ApiNode(n, n2, n3, 0, null, string2, string3, string4, parentPath, null, null, request, string5, null, null, 26136, null);
        if (hasDocs) {
            result.setDocs((Object)docInfo);
            GlobalObjectStorageService cacheService = (GlobalObjectStorageService)ApplicationManager.getApplication().getService(GlobalObjectStorageService.class);
            cacheService.appendToList("DOCS_OBJECT_CLASS_NODE_LIST", result);
        }
        return result;
    }

    public static /* synthetic */ ApiNode makeClassNode$default(TreeBuilder treeBuilder, ClassHelper classHelper, PsiClass psiClass, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeClassNode");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return treeBuilder.makeClassNode(classHelper, psiClass, string, bl);
    }

    @Nullable
    public final ApiNode makeMethodNode(@NotNull MethodHelper methodHelper, @NotNull PsiMethod psiMethod, @NotNull String prefixPath, @NotNull ApiNode classNode, boolean hasDocs, @NotNull Function2<? super MethodHelper, ? super ApiRequest, String> callback) {
        Intrinsics.checkNotNullParameter((Object)methodHelper, (String)"methodHelper");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        Intrinsics.checkNotNullParameter((Object)prefixPath, (String)"prefixPath");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Pair<DocInfo, Map<String, DocInfo>> pair = new DocResolver().resolve((PsiElement)psiMethod, new LinkedHashMap(), CodeType.METHOD, hasDocs);
        DocInfo docInfo = (DocInfo)pair.component1();
        Map implicitParams = (Map)pair.component2();
        ApiRequest apiRequest = MethodHelper.getMethodNodeCoreInfo$default(methodHelper, classNode, false, implicitParams, hasDocs, 2, null);
        if (apiRequest == null) {
            return null;
        }
        ApiRequest request = apiRequest;
        request.setPath(PathUtils.INSTANCE.normalizeToAsyncTestPath(request.getPath()));
        request.setName(psiMethod.getName());
        request.setAlias(docInfo.getTitle());
        request.setDesc(docInfo.getDescription());
        String hash = HashUtilsKt.calculateSafeHash(request);
        request.setHash(hash);
        String requestKey = (String)callback.invoke((Object)methodHelper, (Object)request);
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.INTERFACE_NODE.getCode();
        int n3 = CodeType.METHOD.getCode();
        String string = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        String string3 = prefixPath + "." + psiMethod.getName() + "[" + CodeType.METHOD.getCode() + "]";
        String string4 = docInfo.getTitle();
        String string5 = docInfo.getDescription();
        String string6 = request.getPath();
        String string7 = request.getMethod();
        ApiNode result = new ApiNode(n, n2, n3, 0, string7, string2, string4, string5, string3, null, requestKey, null, string6, hash, null, 18952, null);
        if (hasDocs) {
            result.setDocs((Object)docInfo);
        }
        return result;
    }

    public static /* synthetic */ ApiNode makeMethodNode$default(TreeBuilder treeBuilder, MethodHelper methodHelper, PsiMethod psiMethod, String string, ApiNode apiNode, boolean bl, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeMethodNode");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return treeBuilder.makeMethodNode(methodHelper, psiMethod, string, apiNode, bl, (Function2<? super MethodHelper, ? super ApiRequest, String>)function2);
    }

    @Nullable
    public final ApiNode makeMethodExcludeParam(@NotNull MethodHelper methodHelper, @NotNull PsiMethod psiMethod, @NotNull String prefixPath, @NotNull ApiNode classNode) {
        Intrinsics.checkNotNullParameter((Object)methodHelper, (String)"methodHelper");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        Intrinsics.checkNotNullParameter((Object)prefixPath, (String)"prefixPath");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        ApiRequest apiRequest = MethodHelper.getMethodNodeCoreInfo$default(methodHelper, classNode, true, null, false, 12, null);
        if (apiRequest == null) {
            return null;
        }
        ApiRequest request = apiRequest;
        request.setPath(PathUtils.INSTANCE.normalizeToAsyncTestPath(request.getPath()));
        String string = TreeBuilder.makeMethodExcludeParam$getRequestKey(request);
        if (string == null) {
            return null;
        }
        String requestKey = string;
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.INTERFACE_NODE.getCode();
        int n3 = CodeType.METHOD.getCode();
        String string2 = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2;
        String string4 = prefixPath + "." + psiMethod.getName();
        String string5 = request.getPath();
        String string6 = request.getMethod();
        return new ApiNode(n, n2, n3, 0, string6, string3, null, null, string4, null, requestKey, null, string5, null, null, 27336, null);
    }

    private static final String makeMethodExcludeParam$getRequestKey(ApiRequest request) {
        if (request.getMethod() == null) {
            return null;
        }
        String string = request.getMethod();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2 + ":" + request.getPath();
    }
}

