/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.sheldon.idea.plugin.api.utils.build.BuildRootTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/PsiPathResolver;", "", "<init>", "()V", "resolve", "project", "Lcom/intellij/openapi/project/Project;", "pathStr", "", "findInModuleRoots", "module", "Lcom/intellij/openapi/module/Module;", "segment", "Lcom/sheldon/idea/plugin/api/utils/build/PsiPathResolver$PathSegment;", "findInDirectory", "dir", "Lcom/intellij/psi/PsiDirectory;", "findInClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "parsePath", "", "PathSegment", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nPsiPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiPathResolver.kt\ncom/sheldon/idea/plugin/api/utils/build/PsiPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n1#2:88\n1310#3,2:76\n1611#4,9:78\n1863#4:87\n1864#4:89\n1620#4:90\n*S KotlinDebug\n*F\n+ 1 PsiPathResolver.kt\ncom/sheldon/idea/plugin/api/utils/build/PsiPathResolver\n*L\n64#1:88\n49#1:76,2\n64#1:78,9\n64#1:87\n64#1:89\n64#1:90\n*E\n"})
public final class PsiPathResolver {
    @NotNull
    public static final PsiPathResolver INSTANCE = new PsiPathResolver();

    private PsiPathResolver() {
    }

    @Nullable
    public final Object resolve(@NotNull Project project, @NotNull String pathStr) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pathStr, (String)"pathStr");
        List<PathSegment> segments = this.parsePath(pathStr);
        if (segments.isEmpty()) {
            return null;
        }
        PathSegment moduleSegment = segments.get(0);
        if (moduleSegment.getType() != 0) {
            return null;
        }
        Module module = ModuleManager.Companion.getInstance(project).findModuleByName(moduleSegment.getName());
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (segments.size() == 1) {
            return module2;
        }
        Object currentElement = module2;
        int n = segments.size();
        for (int i = 1; i < n; ++i) {
            Object nextElement;
            PathSegment segment = segments.get(i);
            Module module3 = currentElement;
            Object object = module3 instanceof Module ? this.findInModuleRoots((Module)currentElement, segment) : (module3 instanceof PsiDirectory ? this.findInDirectory((PsiDirectory)currentElement, segment) : (nextElement = module3 instanceof PsiClass ? this.findInClass((PsiClass)currentElement, segment) : null));
            if (nextElement == null) {
                System.out.println((Object)("PSI \u89e3\u6790\u4e2d\u65ad: \u5728 " + currentElement.getClass().getSimpleName() + " \u4e2d\u627e\u4e0d\u5230 " + segment.getName() + "[" + segment.getType() + "]"));
                return null;
            }
            currentElement = nextElement;
        }
        return currentElement;
    }

    private final Object findInModuleRoots(Module module, PathSegment segment) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiDirectory psiDirectory = new BuildRootTree(project).getBaseDir(module);
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory rootDir = psiDirectory;
        return this.findInDirectory(rootDir, segment);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Object findInDirectory(PsiDirectory dir, PathSegment segment) {
        switch (segment.getType()) {
            case 1: {
                v0 = (PsiElement)dir.findSubdirectory(segment.getName());
                break;
            }
            case 2: {
                v1 = JavaDirectoryService.getInstance().getClasses(dir);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getClasses(...)");
                var5_3 = v1;
                var7_7 = var5_3.length;
                for (var6_4 = 0; var6_4 < var7_7; ++var6_4) {
                    var8_8 = var5_3[var6_4];
                    it /* !! */  = (PsiClass)var8_8;
                    $i$a$-find-PsiPathResolver$findInDirectory$psiClass$1 = false;
                    if (!Intrinsics.areEqual((Object)it /* !! */ .getName(), (Object)segment.getName())) continue;
                    v2 = var8_8;
                    ** GOTO lbl18
                }
                v2 = null;
lbl18:
                // 2 sources

                psiClass = (PsiClass)v2;
                if (psiClass != null) ** GOTO lbl43
                v3 = dir.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getFiles(...)");
                for (PsiClass it : (Object[])v3) {
                    it = (PsiFile)it /* !! */ ;
                    $i$a$-find-PsiPathResolver$findInDirectory$file$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getVirtualFile().getNameWithoutExtension(), (Object)segment.getName())) continue;
                    v4 /* !! */  = it /* !! */ ;
                    ** GOTO lbl29
                }
                v4 /* !! */  = null;
lbl29:
                // 2 sources

                file = (PsiFile)v4 /* !! */ ;
                if (!(file instanceof PsiClassOwner)) ** GOTO lbl43
                v5 = ((PsiClassOwner)file).getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getClasses(...)");
                $this$firstOrNull$iv = v5;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (PsiClass)element$iv;
                    $i$a$-firstOrNull-PsiPathResolver$findInDirectory$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)segment.getName())) continue;
                    v6 = element$iv;
                    ** GOTO lbl42
                }
                v6 = null;
lbl42:
                // 2 sources

                psiClass = (PsiClass)v6;
lbl43:
                // 3 sources

                v0 = (PsiElement)var3_14;
                break;
            }
            default: {
                v0 = null;
            }
        }
        return v0;
    }

    private final Object findInClass(PsiClass psiClass, PathSegment segment) {
        if (segment.getType() == 3) {
            PsiMethod[] psiMethodArray = psiClass.findMethodsByName(segment.getName(), false);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
            return ArraysKt.firstOrNull((Object[])psiMethodArray);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PathSegment> parsePath(String pathStr) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{"."};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)pathStr, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PathSegment pathSegment;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String segmentStr = (String)element$iv$iv;
            boolean bl2 = false;
            MatchResult match = Regex.find$default((Regex)new Regex("^(.*)\\[(\\d+)\\]$"), (CharSequence)segmentStr, (int)0, (int)2, null);
            if (match != null) {
                MatchResult.Destructured destructured = match.getDestructured();
                String name = (String)destructured.getMatch().getGroupValues().get(1);
                String type2 = (String)destructured.getMatch().getGroupValues().get(2);
                pathSegment = new PathSegment(name, Integer.parseInt(type2));
            } else {
                pathSegment = null;
            }
            if (pathSegment == null) continue;
            PathSegment it$iv$iv = pathSegment;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/PsiPathResolver$PathSegment;", "", "name", "", "type", "", "<init>", "(Ljava/lang/String;I)V", "getName", "()Ljava/lang/String;", "getType", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "idea-plugin"})
    public static final class PathSegment {
        @NotNull
        private final String name;
        private final int type;

        public PathSegment(@NotNull String name, int type2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.type = type2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.type;
        }

        @NotNull
        public final PathSegment copy(@NotNull String name, int type2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new PathSegment(name, type2);
        }

        public static /* synthetic */ PathSegment copy$default(PathSegment pathSegment, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = pathSegment.name;
            }
            if ((n2 & 2) != 0) {
                n = pathSegment.type;
            }
            return pathSegment.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "PathSegment(name=" + this.name + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.type);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathSegment)) {
                return false;
            }
            PathSegment pathSegment = (PathSegment)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pathSegment.name)) {
                return false;
            }
            return this.type == pathSegment.type;
        }
    }
}

