/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.sheldon.idea.plugin.api.utils.build.resolver.ResolverHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!J\u000e\u0010$\u001a\u00020#2\u0006\u0010 \u001a\u00020!J\u000e\u0010%\u001a\u00020#2\u0006\u0010 \u001a\u00020!J\u001e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020*R\u0017\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\u00020\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\bR\u0017\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\bR\u0017\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\bR\u0017\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001d\u0010\b\u00a8\u0006+"}, d2={"Lcom/sheldon/idea/plugin/api/utils/TypeUtils;", "", "<init>", "()V", "INT", "Lcom/intellij/psi/PsiPrimitiveType;", "getINT$annotations", "getINT", "()Lcom/intellij/psi/PsiPrimitiveType;", "LONG", "getLONG$annotations", "getLONG", "SHORT", "getSHORT$annotations", "getSHORT", "BYTE", "getBYTE$annotations", "getBYTE", "DOUBLE", "getDOUBLE$annotations", "getDOUBLE", "FLOAT", "getFLOAT$annotations", "getFLOAT", "BOOLEAN", "getBOOLEAN$annotations", "getBOOLEAN", "VOID", "getVOID$annotations", "getVOID", "mapToAsyncType", "", "type", "Lcom/intellij/psi/PsiType;", "isArrayOrCollection", "", "isMapType", "isGeneralObject", "getRealTypeForMethod", "method", "Lcom/intellij/psi/PsiMethod;", "currentClass", "Lcom/intellij/psi/PsiClass;", "idea-plugin"})
public final class TypeUtils {
    @NotNull
    public static final TypeUtils INSTANCE = new TypeUtils();
    @NotNull
    private static final PsiPrimitiveType INT;
    @NotNull
    private static final PsiPrimitiveType LONG;
    @NotNull
    private static final PsiPrimitiveType SHORT;
    @NotNull
    private static final PsiPrimitiveType BYTE;
    @NotNull
    private static final PsiPrimitiveType DOUBLE;
    @NotNull
    private static final PsiPrimitiveType FLOAT;
    @NotNull
    private static final PsiPrimitiveType BOOLEAN;
    @NotNull
    private static final PsiPrimitiveType VOID;

    private TypeUtils() {
    }

    @NotNull
    public final PsiPrimitiveType getINT() {
        return INT;
    }

    public static /* synthetic */ void getINT$annotations() {
    }

    @NotNull
    public final PsiPrimitiveType getLONG() {
        return LONG;
    }

    public static /* synthetic */ void getLONG$annotations() {
    }

    @NotNull
    public final PsiPrimitiveType getSHORT() {
        return SHORT;
    }

    public static /* synthetic */ void getSHORT$annotations() {
    }

    @NotNull
    public final PsiPrimitiveType getBYTE() {
        return BYTE;
    }

    public static /* synthetic */ void getBYTE$annotations() {
    }

    @NotNull
    public final PsiPrimitiveType getDOUBLE() {
        return DOUBLE;
    }

    public static /* synthetic */ void getDOUBLE$annotations() {
    }

    @NotNull
    public final PsiPrimitiveType getFLOAT() {
        return FLOAT;
    }

    public static /* synthetic */ void getFLOAT$annotations() {
    }

    @NotNull
    public final PsiPrimitiveType getBOOLEAN() {
        return BOOLEAN;
    }

    public static /* synthetic */ void getBOOLEAN$annotations() {
    }

    @NotNull
    public final PsiPrimitiveType getVOID() {
        return VOID;
    }

    public static /* synthetic */ void getVOID$annotations() {
    }

    @NotNull
    public final String mapToAsyncType(@NotNull PsiType type2) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                String string = type2.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
                String canonicalText = string;
                if (ResolverHelper.Companion.isMultipartFile(type2)) {
                    return "files";
                }
                if (this.isArrayOrCollection(type2)) {
                    return "array";
                }
                if (INT.isAssignableFrom(type2) || LONG.isAssignableFrom(type2) || SHORT.isAssignableFrom(type2) || BYTE.isAssignableFrom(type2) || Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.Integer") || Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.Long")) {
                    return "integer";
                }
                if (DOUBLE.isAssignableFrom(type2) || FLOAT.isAssignableFrom(type2) || Intrinsics.areEqual((Object)canonicalText, (Object)"java.math.BigDecimal")) {
                    return "number";
                }
                if (BOOLEAN.isAssignableFrom(type2) || Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.Boolean")) {
                    return "boolean";
                }
                if (VOID.isAssignableFrom(type2)) {
                    return "null";
                }
                if (Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.String") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Date") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.time.temporal.Temporal")) break block10;
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
                boolean bl = psiClass != null ? psiClass.isEnum() : false;
                if (!bl) break block11;
            }
            return "string";
        }
        if (this.isMapType(type2)) {
            return "object";
        }
        return "ds";
    }

    public final boolean isArrayOrCollection(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2 instanceof PsiArrayType) {
            return true;
        }
        String string = type2.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        if (StringsKt.startsWith$default((String)string, (String)"java.util.Collection", (boolean)false, (int)2, null)) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection");
    }

    public final boolean isMapType(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        String string = type2.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        if (StringsKt.startsWith$default((String)string, (String)"java.util.Map", (boolean)false, (int)2, null)) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
    }

    public final boolean isGeneralObject(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return Intrinsics.areEqual((Object)type2.getCanonicalText(), (Object)"java.lang.Object");
    }

    @NotNull
    public final PsiType getRealTypeForMethod(@NotNull PsiMethod method, @NotNull PsiType type2, @NotNull PsiClass currentClass) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)currentClass, (String)"currentClass");
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && !Intrinsics.areEqual((Object)containingClass, (Object)currentClass)) {
            PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)currentClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSuperClassSubstitutor(...)");
            PsiSubstitutor substitutor = psiSubstitutor;
            psiType = substitutor.substitute(type2);
        } else {
            psiType = type2;
        }
        PsiType realType = psiType;
        Intrinsics.checkNotNull((Object)realType);
        return realType;
    }

    static {
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"INT");
        INT = psiPrimitiveType;
        PsiPrimitiveType psiPrimitiveType2 = PsiType.LONG;
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType2, (String)"LONG");
        LONG = psiPrimitiveType2;
        PsiPrimitiveType psiPrimitiveType3 = PsiType.SHORT;
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType3, (String)"SHORT");
        SHORT = psiPrimitiveType3;
        PsiPrimitiveType psiPrimitiveType4 = PsiType.BYTE;
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType4, (String)"BYTE");
        BYTE = psiPrimitiveType4;
        PsiPrimitiveType psiPrimitiveType5 = PsiType.DOUBLE;
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType5, (String)"DOUBLE");
        DOUBLE = psiPrimitiveType5;
        PsiPrimitiveType psiPrimitiveType6 = PsiType.FLOAT;
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType6, (String)"FLOAT");
        FLOAT = psiPrimitiveType6;
        PsiPrimitiveType psiPrimitiveType7 = PsiType.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType7, (String)"BOOLEAN");
        BOOLEAN = psiPrimitiveType7;
        PsiPrimitiveType psiPrimitiveType8 = PsiType.VOID;
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType8, (String)"VOID");
        VOID = psiPrimitiveType8;
    }
}

