/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/sheldon/idea/plugin/api/utils/PathUtils;", "", "<init>", "()V", "normalizeToAsyncTestPath", "", "springPath", "extractBalancedBraceContent", "text", "startIndex", "", "getVariableName", "content", "idea-plugin"})
public final class PathUtils {
    @NotNull
    public static final PathUtils INSTANCE = new PathUtils();

    private PathUtils() {
    }

    @NotNull
    public final String normalizeToAsyncTestPath(@Nullable String springPath) {
        if (springPath == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int length = springPath.length();
        int i = 0;
        while (i < length) {
            String variableContent;
            char c = springPath.charAt(i);
            if (c == '{' && (variableContent = this.extractBalancedBraceContent(springPath, i)) != null) {
                String varName = this.getVariableName(variableContent);
                result.append("{{").append(varName).append("}}");
                i += variableContent.length() + 2;
                continue;
            }
            result.append(c);
            ++i;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String extractBalancedBraceContent(String text, int startIndex) {
        int balance = 0;
        int n = text.length();
        for (int j = startIndex; j < n; ++j) {
            char c = text.charAt(j);
            switch (c) {
                case '{': {
                    ++balance;
                    break;
                }
                case '}': {
                    --balance;
                }
            }
            if (balance != 0) continue;
            String string = text.substring(startIndex + 1, j);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return null;
    }

    private final String getVariableName(String content) {
        String string;
        int colonIndex = StringsKt.indexOf$default((CharSequence)content, (char)':', (int)0, (boolean)false, (int)6, null);
        if (colonIndex != -1) {
            String string2 = content.substring(0, colonIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = ((Object)StringsKt.trim((CharSequence)content)).toString();
        }
        return string;
    }
}

