/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.sheldon.idea.plugin.api.model.FormDataField;
import com.sheldon.idea.plugin.api.utils.HttpMethod;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0001J\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001bH\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 0\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/sheldon/idea/plugin/api/utils/HttpExecutor;", "", "<init>", "()V", "url", "", "method", "queryParams", "", "headers", "body", "setUrl", "", "setMethod", "setParam", "key", "value", "setHeader", "setBody", "send", "sendAndGetResponse", "Lokhttp3/Response;", "createRequestBody", "Lokhttp3/RequestBody;", "isMultipart", "", "map", "", "buildFormBody", "buildMultipartBody", "Lokhttp3/MultipartBody;", "formData", "Lcom/sheldon/idea/plugin/api/model/FormDataField;", "Companion", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nNetworkClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkClient.kt\ncom/sheldon/idea/plugin/api/utils/HttpExecutor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n216#2,2:154\n216#2,2:156\n216#2,2:158\n216#2,2:160\n216#2,2:178\n216#2,2:180\n1611#3,9:162\n1863#3:171\n1864#3:173\n1620#3:174\n1755#3,3:175\n1#4:172\n*S KotlinDebug\n*F\n+ 1 NetworkClient.kt\ncom/sheldon/idea/plugin/api/utils/HttpExecutor\n*L\n44#1:154,2\n50#1:156,2\n68#1:158,2\n74#1:160,2\n117#1:178,2\n124#1:180,2\n97#1:162,9\n97#1:171\n97#1:173\n97#1:174\n113#1:175,3\n97#1:172\n*E\n"})
public final class HttpExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String url = "";
    @NotNull
    private String method = "GET";
    @NotNull
    private final Map<String, String> queryParams = new LinkedHashMap();
    @NotNull
    private final Map<String, String> headers = new LinkedHashMap();
    @Nullable
    private Object body;
    @NotNull
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();

    public final void setUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    public final void setMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        this.method = string;
    }

    public final void setParam(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.queryParams.put(key, value);
    }

    public final void setHeader(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.headers.put(key, value);
    }

    public final void setBody(@NotNull Object body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.body = body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String send() {
        try {
            Object object;
            Object object2;
            Object object3;
            HttpUrl.Builder builder;
            HttpUrl httpUrl = HttpUrl.Companion.parse(this.url);
            if (httpUrl == null || (builder = httpUrl.newBuilder()) == null) {
                throw new IllegalArgumentException("\u65e0\u6548\u7684 URL: " + this.url);
            }
            HttpUrl.Builder httpUrlBuilder = builder;
            Map<String, String> $this$forEach$iv = this.queryParams;
            boolean $i$f$forEach = false;
            for (Map.Entry<String, String> element$iv : $this$forEach$iv.entrySet()) {
                object3 = element$iv;
                boolean bl = false;
                String k = object3.getKey();
                String v = object3.getValue();
                httpUrlBuilder.addQueryParameter(k, v);
            }
            HttpUrl finalUrl = httpUrlBuilder.build();
            RequestBody requestBody = this.createRequestBody();
            Request.Builder $this$send_u24lambda_u242 = object2 = new Request.Builder().url(finalUrl);
            boolean bl = false;
            Map<String, String> $this$forEach$iv2 = this.headers;
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String k = entry.getKey();
                String v = entry.getValue();
                $this$send_u24lambda_u242.addHeader(k, v);
            }
            Request request = object2.method(this.method, requestBody).build();
            object2 = (Closeable)client.newCall(request).execute();
            object3 = null;
            try {
                Response response = (Response)object2;
                boolean bl3 = false;
                Object object4 = response.body();
                if (object4 == null || (object4 = object4.string()) == null) {
                    object4 = "";
                }
                object = object4;
            }
            catch (Throwable throwable) {
                try {
                    object3 = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)object2, object3);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @NotNull
    public final Response sendAndGetResponse() {
        try {
            Request.Builder builder;
            HttpUrl.Builder builder2;
            HttpUrl httpUrl = HttpUrl.Companion.parse(this.url);
            if (httpUrl == null || (builder2 = httpUrl.newBuilder()) == null) {
                throw new IllegalArgumentException("\u65e0\u6548\u7684 URL: " + this.url);
            }
            HttpUrl.Builder httpUrlBuilder = builder2;
            Map<String, String> $this$forEach$iv = this.queryParams;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String k = entry.getKey();
                String v = entry.getValue();
                httpUrlBuilder.addQueryParameter(k, v);
            }
            HttpUrl finalUrl = httpUrlBuilder.build();
            RequestBody requestBody = this.createRequestBody();
            Request.Builder $this$sendAndGetResponse_u24lambda_u246 = builder = new Request.Builder().url(finalUrl);
            boolean bl = false;
            Map<String, String> $this$forEach$iv2 = this.headers;
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator2.next();
                boolean bl2 = false;
                String k = entry.getKey();
                String v = entry.getValue();
                $this$sendAndGetResponse_u24lambda_u246.addHeader(k, v);
            }
            Request request = builder.method(this.method, requestBody).build();
            return client.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final RequestBody createRequestBody() {
        RequestBody requestBody;
        if (!HttpMethod.INSTANCE.requiresRequestBody(this.method) && this.body == null) {
            return null;
        }
        if (HttpMethod.INSTANCE.requiresRequestBody(this.method) && this.body == null) {
            return RequestBody.Companion.create(new byte[0], null, 0, 0);
        }
        Object currentBody = this.body;
        if (currentBody instanceof String) {
            requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (String)((String)currentBody), null, (int)1, null);
        } else if (currentBody instanceof Map) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((Map)currentBody).entrySet();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Object k = entry.getKey();
                Object v = entry.getValue();
                if ((k instanceof String ? (String)k : null) == null) {
                    pair = null;
                } else {
                    String key;
                    key = key;
                    if ((v instanceof FormDataField ? (FormDataField)v : null) == null) {
                        pair = null;
                    } else {
                        FormDataField value;
                        value = value;
                        pair = TuplesKt.to((Object)key, (Object)value);
                    }
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map typedMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            requestBody = (RequestBody)(!typedMap.isEmpty() ? this.buildMultipartBody(typedMap) : null);
        } else {
            requestBody = null;
        }
        return requestBody;
    }

    private final boolean isMultipart(Map<?, ?> map) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = map.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(it instanceof File)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final RequestBody buildFormBody(Map<?, ?> map) {
        FormBody.Builder builder = new FormBody.Builder(null, 1, null);
        Map<?, ?> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> element$iv;
            Map.Entry<?, ?> entry = element$iv = iterator.next();
            boolean bl = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            builder.add(String.valueOf(k), String.valueOf(v));
        }
        return (RequestBody)builder.build();
    }

    @NotNull
    public final MultipartBody buildMultipartBody(@NotNull Map<String, FormDataField> formData) {
        Intrinsics.checkNotNullParameter(formData, (String)"formData");
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        Map<String, FormDataField> $this$forEach$iv = formData;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, FormDataField>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Map.Entry<String, FormDataField> element$iv;
            Map.Entry<String, FormDataField> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            FormDataField data = entry.getValue();
            if (Intrinsics.areEqual((Object)data.getType(), (Object)"text")) {
                builder.addFormDataPart(key, data.getValue());
                continue;
            }
            if (!(!((Collection)data.getFileList()).isEmpty())) continue;
            Intrinsics.checkNotNullExpressionValue(data.getFileList().iterator(), (String)"iterator(...)");
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String filePath = (String)e;
                File file = new File(filePath);
                if (!file.exists()) continue;
                MediaType mimeType = MediaType.Companion.parse(data.getContentType());
                RequestBody fileBody = RequestBody.Companion.create(file, mimeType);
                builder.addFormDataPart(key, file.getName(), fileBody);
            }
        }
        return builder.build();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/sheldon/idea/plugin/api/utils/HttpExecutor$Companion;", "", "<init>", "()V", "client", "Lokhttp3/OkHttpClient;", "idea-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

