/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.sheldon.idea.plugin.api.method.AsyncTestVariableNode;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.model.DataStructure;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u00a8\u0006\u0004"}, d2={"calculateSafeHash", "", "Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "Lcom/sheldon/idea/plugin/api/model/DataStructure;", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nHashUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashUtils.kt\ncom/sheldon/idea/plugin/api/utils/HashUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1053#2:89\n1863#2,2:90\n1053#2:92\n1863#2,2:93\n1863#2,2:95\n1863#2,2:97\n1863#2,2:99\n1863#2,2:101\n*S KotlinDebug\n*F\n+ 1 HashUtils.kt\ncom/sheldon/idea/plugin/api/utils/HashUtilsKt\n*L\n23#1:89\n23#1:90,2\n28#1:92\n28#1:93,2\n38#1:95,2\n57#1:97,2\n52#1:99,2\n81#1:101,2\n*E\n"})
public final class HashUtilsKt {
    @NotNull
    public static final String calculateSafeHash(@NotNull ApiRequest $this$calculateSafeHash) {
        AsyncTestVariableNode it;
        Intrinsics.checkNotNullParameter((Object)$this$calculateSafeHash, (String)"<this>");
        MessageDigest md = MessageDigest.getInstance("MD5");
        HashUtilsKt.calculateSafeHash$update(md, $this$calculateSafeHash.getName());
        HashUtilsKt.calculateSafeHash$update(md, $this$calculateSafeHash.getAlias());
        HashUtilsKt.calculateSafeHash$update(md, $this$calculateSafeHash.getDesc());
        HashUtilsKt.calculateSafeHash$update(md, $this$calculateSafeHash.getMethod());
        HashUtilsKt.calculateSafeHash$update(md, $this$calculateSafeHash.getPath());
        Iterable $this$sortedBy$iv = $this$calculateSafeHash.getHeaders();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AsyncTestVariableNode it = (AsyncTestVariableNode)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (AsyncTestVariableNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AsyncTestVariableNode)element$iv;
            boolean bl = false;
            HashUtilsKt.calculateSafeHash$update(md, it.getName());
            HashUtilsKt.calculateSafeHash$updateBool(md, it.getRequired());
            HashUtilsKt.calculateSafeHash$update(md, it.getDefaultValue());
        }
        $this$sortedBy$iv = $this$calculateSafeHash.getQuery();
        $i$f$sortedBy = false;
        $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AsyncTestVariableNode it = (AsyncTestVariableNode)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (AsyncTestVariableNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AsyncTestVariableNode)element$iv;
            boolean bl = false;
            HashUtilsKt.calculateSafeHash$update(md, it.getType());
            HashUtilsKt.calculateSafeHash$update(md, it.getName());
            HashUtilsKt.calculateSafeHash$updateBool(md, it.getRequired());
            HashUtilsKt.calculateSafeHash$update(md, it.getDefaultValue());
        }
        String string = $this$calculateSafeHash.getBodyType();
        if (string == null) {
            string = "none";
        }
        String type2 = string;
        HashUtilsKt.calculateSafeHash$update(md, type2);
        String string2 = type2;
        if (Intrinsics.areEqual((Object)string2, (Object)"form-data")) {
            $this$forEach$iv = $this$calculateSafeHash.getFormData().getData();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                AsyncTestVariableNode it2 = (AsyncTestVariableNode)element$iv;
                boolean bl = false;
                HashUtilsKt.calculateSafeHash$update(md, it2.getType());
                HashUtilsKt.calculateSafeHash$update(md, it2.getName());
                HashUtilsKt.calculateSafeHash$update(md, it2.getContentType());
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)"json")) {
            $this$forEach$iv = $this$calculateSafeHash.getJson();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                AsyncTestVariableNode it3 = (AsyncTestVariableNode)element$iv;
                boolean bl = false;
                HashUtilsKt.calculateSafeHash$processJsonNode(md, it3);
            }
        }
        String string3 = new BigInteger(1, md.digest()).toString(36);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @NotNull
    public static final String calculateSafeHash(@NotNull DataStructure $this$calculateSafeHash) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateSafeHash, (String)"<this>");
        if ($this$calculateSafeHash.getData().isEmpty()) {
            return "empty";
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        HashUtilsKt.calculateSafeHash$processJsonNode$9(md, (AsyncTestVariableNode)$this$calculateSafeHash.getData().get(0));
        String string = new BigInteger(1, md.digest()).toString(36);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void calculateSafeHash$update(MessageDigest md, String str) {
        CharSequence charSequence = str;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = str;
            byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            md.update(byArray);
        }
        md.update((byte)0);
    }

    private static final void calculateSafeHash$updateBool(MessageDigest md, boolean b) {
        md.update(b ? (byte)1 : 0);
    }

    private static final void calculateSafeHash$processJsonNode(MessageDigest md, AsyncTestVariableNode node) {
        HashUtilsKt.calculateSafeHash$update(md, node.getType());
        HashUtilsKt.calculateSafeHash$update(md, node.getName());
        HashUtilsKt.calculateSafeHash$update(md, node.getDsTarget());
        HashUtilsKt.calculateSafeHash$update(md, node.getStatement());
        HashUtilsKt.calculateSafeHash$update(md, node.getDefaultValue());
        md.update((byte)2);
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncTestVariableNode child = (AsyncTestVariableNode)element$iv;
            boolean bl = false;
            HashUtilsKt.calculateSafeHash$processJsonNode(md, child);
        }
        md.update((byte)3);
    }

    private static final void calculateSafeHash$update$7(MessageDigest md, String str) {
        CharSequence charSequence = str;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = str;
            byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            md.update(byArray);
        }
        md.update((byte)0);
    }

    private static final void calculateSafeHash$processJsonNode$9(MessageDigest md, AsyncTestVariableNode node) {
        HashUtilsKt.calculateSafeHash$update$7(md, node.getType());
        HashUtilsKt.calculateSafeHash$update$7(md, node.getName());
        HashUtilsKt.calculateSafeHash$update$7(md, node.getDsTarget());
        HashUtilsKt.calculateSafeHash$update$7(md, node.getStatement());
        HashUtilsKt.calculateSafeHash$update$7(md, node.getContentType());
        HashUtilsKt.calculateSafeHash$update$7(md, node.getRequired() ? "1" : "0");
        md.update((byte)2);
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncTestVariableNode child = (AsyncTestVariableNode)element$iv;
            boolean bl = false;
            HashUtilsKt.calculateSafeHash$processJsonNode$9(md, child);
        }
        md.update((byte)3);
    }
}

