/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.front.dashboard.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.sheldon.idea.plugin.api.front.dashboard.utils.CachedResponse;
import com.sheldon.idea.plugin.api.utils.build.docs.export.openapi3.utils.ExportHelper;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007\u001a\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0010\u001a\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"handleResponse", "", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/sheldon/idea/plugin/api/front/dashboard/utils/CachedResponse;", "updateUiCallback", "Lkotlin/Function2;", "", "resolveFileName", "isJsonType", "", "mediaType", "Lokhttp3/MediaType;", "isTextType", "getFileNameFromResponse", "Lokhttp3/Response;", "byteCountToDisplaySize", "size", "", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nResponseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseHelper.kt\ncom/sheldon/idea/plugin/api/front/dashboard/utils/ResponseHelperKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n462#2:118\n412#2:119\n1246#3,4:120\n*S KotlinDebug\n*F\n+ 1 ResponseHelper.kt\ncom/sheldon/idea/plugin/api/front/dashboard/utils/ResponseHelperKt\n*L\n21#1:118\n21#1:119\n21#1:120,4\n*E\n"})
public final class ResponseHelperKt {
    /*
     * WARNING - void declaration
     */
    public static final void handleResponse(@NotNull Project project, @NotNull CachedResponse response, @NotNull Function2<? super String, ? super String, Unit> updateUiCallback) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(updateUiCallback, (String)"updateUiCallback");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Map $this$mapValues$iv = response.getHeaders().toMultimap();
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)entry.getValue()), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            map3.put(k, string);
        }
        Map headersMap = destination$iv$iv;
        String formattedHeaders = gson.toJson((Object)headersMap);
        MediaType mediaType = response.getMediaType();
        boolean isText = ResponseHelperKt.isTextType(mediaType);
        byte[] bodyBytes = response.getBodyBytes();
        if (isText) {
            String string;
            Object object = mediaType;
            if (object == null || (object = MediaType.charset$default((MediaType)object, null, (int)1, null)) == null) {
                object = Charsets.UTF_8;
            }
            $this$associateByTo$iv$iv$iv = object;
            String bodyString = new String(bodyBytes, (Charset)((Object)$this$associateByTo$iv$iv$iv));
            if (ResponseHelperKt.isJsonType(mediaType)) {
                String string2;
                try {
                    string2 = gson.toJson(JsonParser.parseString((String)bodyString));
                }
                catch (Exception exception) {
                    string2 = bodyString;
                }
                string = string2;
            } else {
                string = bodyString;
            }
            String finalBody = string;
            ApplicationManager.getApplication().invokeLater(() -> ResponseHelperKt.handleResponse$lambda$1(updateUiCallback, formattedHeaders, finalBody));
        } else {
            ApplicationManager.getApplication().invokeLater(() -> ResponseHelperKt.handleResponse$lambda$2(updateUiCallback, formattedHeaders, bodyBytes));
            String fileName = ResponseHelperKt.resolveFileName(response);
            String extension = StringsKt.substringAfterLast((String)fileName, (String)".", (String)"");
            ApplicationManager.getApplication().invokeLater(() -> ResponseHelperKt.handleResponse$lambda$3(project, bodyBytes, fileName, extension));
        }
    }

    @NotNull
    public static final String resolveFileName(@NotNull CachedResponse response) {
        Object object;
        Regex pattern;
        MatchResult match;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String contentDisposition = response.getHeaders().get("Content-Disposition");
        if (contentDisposition != null && (match = Regex.find$default((Regex)(pattern = new Regex("filename=\"?([^;\"]+)\"?", RegexOption.IGNORE_CASE)), (CharSequence)contentDisposition, (int)0, (int)2, null)) != null) {
            return ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString();
        }
        try {
            String path = new URI(response.getRequestUrl()).getPath();
            Intrinsics.checkNotNull((Object)path);
            String fileNameFromUrl = StringsKt.substringAfterLast$default((String)path, (String)"/", null, (int)2, null);
            if (((CharSequence)fileNameFromUrl).length() > 0 && StringsKt.contains$default((CharSequence)fileNameFromUrl, (CharSequence)".", (boolean)false, (int)2, null)) {
                return fileNameFromUrl;
            }
        }
        catch (Exception path) {
            // empty catch block
        }
        if ((object = response.getMediaType()) == null || (object = object.subtype()) == null) {
            object = "dat";
        }
        Object subtype = object;
        return "download_file." + (String)subtype;
    }

    public static final boolean isJsonType(@Nullable MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return StringsKt.contains((CharSequence)mediaType.subtype(), (CharSequence)"json", (boolean)true) || StringsKt.contains((CharSequence)mediaType.subtype(), (CharSequence)"javascript", (boolean)true);
    }

    public static final boolean isTextType(@Nullable MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        String type2 = mediaType.type();
        String subtype = mediaType.subtype();
        return Intrinsics.areEqual((Object)type2, (Object)"text") || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"json", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"xml", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"html", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"x-www-form-urlencoded", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String getFileNameFromResponse(@NotNull Response response) {
        Regex pattern;
        MatchResult match;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String contentDisposition = Response.header$default((Response)response, (String)"Content-Disposition", null, (int)2, null);
        if (contentDisposition != null && (match = Regex.find$default((Regex)(pattern = new Regex("filename=\"?([^\";]+)\"?")), (CharSequence)contentDisposition, (int)0, (int)2, null)) != null) {
            return (String)match.getGroupValues().get(1);
        }
        String urlPath = response.request().url().encodedPath();
        String fileNameFromUrl = StringsKt.substringAfterLast$default((String)urlPath, (String)"/", null, (int)2, null);
        if (((CharSequence)fileNameFromUrl).length() > 0 && StringsKt.contains$default((CharSequence)fileNameFromUrl, (CharSequence)".", (boolean)false, (int)2, null)) {
            return fileNameFromUrl;
        }
        Object object = response.body();
        if (object == null || (object = object.contentType()) == null || (object = object.subtype()) == null) {
            object = "dat";
        }
        Object subtype = object;
        return "download_file." + (String)subtype;
    }

    @NotNull
    public static final String byteCountToDisplaySize(long size) {
        int unit = 1024;
        if (size < (long)unit) {
            return size + " B";
        }
        int exp = (int)(Math.log(size) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        String string = "%.1f %sB";
        Object[] objectArray = new Object[]{(double)size / Math.pow(unit, exp), Character.valueOf(pre)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final void handleResponse$lambda$1(Function2 $updateUiCallback, String $formattedHeaders, String $finalBody) {
        Intrinsics.checkNotNull((Object)$formattedHeaders);
        Intrinsics.checkNotNull((Object)$finalBody);
        $updateUiCallback.invoke((Object)$formattedHeaders, (Object)$finalBody);
    }

    private static final void handleResponse$lambda$2(Function2 $updateUiCallback, String $formattedHeaders, byte[] $bodyBytes) {
        Intrinsics.checkNotNull((Object)$formattedHeaders);
        $updateUiCallback.invoke((Object)$formattedHeaders, (Object)("(binary data: " + ResponseHelperKt.byteCountToDisplaySize($bodyBytes.length) + ")"));
    }

    private static final void handleResponse$lambda$3(Project $project, byte[] $bodyBytes, String $fileName, String $extension) {
        ExportHelper.INSTANCE.exportBinaryToFile($project, $bodyBytes, $fileName, $extension, "\u4fdd\u5b58\u6587\u4ef6");
    }
}

