/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.front.dashboard.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.project.Project;
import com.sheldon.idea.plugin.api.front.dashboard.utils.CachedResponse;
import com.sheldon.idea.plugin.api.model.ApiMockRequest;
import com.sheldon.idea.plugin.api.model.FormDataField;
import com.sheldon.idea.plugin.api.utils.HttpExecutor;
import com.sheldon.idea.plugin.api.utils.ThreadingHelperKt;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u000eJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/sheldon/idea/plugin/api/front/dashboard/utils/MockRequestHelper;", "", "<init>", "()V", "send", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/sheldon/idea/plugin/api/model/ApiMockRequest;", "url", "", "bodyType", "callback", "Lkotlin/Function1;", "Lcom/sheldon/idea/plugin/api/front/dashboard/utils/CachedResponse;", "setJsonBody", "jsonString", "httpExecutor", "Lcom/sheldon/idea/plugin/api/utils/HttpExecutor;", "setFormDataBody", "setHeaders", "setParams", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nMockRequestHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockRequestHelper.kt\ncom/sheldon/idea/plugin/api/front/dashboard/utils/MockRequestHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,93:1\n216#2,2:94\n216#2,2:96\n*S KotlinDebug\n*F\n+ 1 MockRequestHelper.kt\ncom/sheldon/idea/plugin/api/front/dashboard/utils/MockRequestHelper\n*L\n82#1:94,2\n89#1:96,2\n*E\n"})
public final class MockRequestHelper {
    @NotNull
    public static final MockRequestHelper INSTANCE = new MockRequestHelper();

    private MockRequestHelper() {
    }

    public final void send(@NotNull Project project, @NotNull ApiMockRequest request, @NotNull String url, @Nullable String bodyType, @NotNull Function1<? super CachedResponse, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ThreadingHelperKt.runBackgroundReadUI(ThreadingHelperKt.context(project), "AST_CALLER_GLOBAL_HTTP_ACTION", false, arg_0 -> MockRequestHelper.send$lambda$0(request, url, bodyType, arg_0), (arg_0, arg_1) -> MockRequestHelper.send$lambda$1(callback, arg_0, arg_1));
    }

    private final void setJsonBody(String jsonString, HttpExecutor httpExecutor) {
        httpExecutor.setBody(jsonString);
    }

    private final void setFormDataBody(String jsonString, HttpExecutor httpExecutor) {
        Gson gson = new Gson();
        Type type2 = new TypeToken<Map<String, ? extends FormDataField>>(){}.getType();
        Object object = gson.fromJson(jsonString, type2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        Map map = (Map)object;
        httpExecutor.setBody(map);
    }

    private final void setHeaders(String jsonString, HttpExecutor httpExecutor) {
        Map map;
        Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
        Object object = new Gson().fromJson(jsonString, type2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        Map $this$forEach$iv = map = (Map)object;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            httpExecutor.setHeader(key, value.toString());
        }
    }

    private final void setParams(String jsonString, HttpExecutor httpExecutor) {
        Map map;
        Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
        Object object = new Gson().fromJson(jsonString, type2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        Map $this$forEach$iv = map = (Map)object;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            httpExecutor.setParam(key, value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CachedResponse send$lambda$0(ApiMockRequest $request, String $url, String $bodyType, Project p) {
        String string;
        HttpExecutor httpExecutor;
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                httpExecutor = new HttpExecutor();
                string = $request.getMethod();
                if (string == null) break block15;
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                string = string2;
                if (string2 != null) break block16;
            }
            string = "GET";
        }
        httpExecutor.setMethod(string);
        httpExecutor.setUrl($url);
        String string3 = $request.getHeaders();
        if (string3 == null) {
            string3 = "{}";
        }
        INSTANCE.setHeaders(string3, httpExecutor);
        String string4 = $request.getQuery();
        if (string4 == null) {
            string4 = "{}";
        }
        INSTANCE.setParams(string4, httpExecutor);
        if ($bodyType != null) {
            if (StringsKt.contains$default((CharSequence)$bodyType, (CharSequence)"application/json", (boolean)false, (int)2, null)) {
                INSTANCE.setJsonBody($request.getBody(), httpExecutor);
            } else if (StringsKt.contains$default((CharSequence)$bodyType, (CharSequence)"multipart/form-data", (boolean)false, (int)2, null)) {
                INSTANCE.setFormDataBody($request.getFormData(), httpExecutor);
            }
        }
        try (Response rawResponse = httpExecutor.sendAndGetResponse();){
            Object object;
            block18: {
                block17: {
                    object = rawResponse.body();
                    if (object == null) break block17;
                    byte[] byArray = object.bytes();
                    object = byArray;
                    if (byArray != null) break block18;
                }
                object = new byte[0];
            }
            Object bytes = object;
            ResponseBody responseBody = rawResponse.body();
            CachedResponse cachedResponse = new CachedResponse(rawResponse.code(), rawResponse.headers(), (byte[])bytes, (MediaType)(responseBody != null ? responseBody.contentType() : null), $url);
            return cachedResponse;
        }
    }

    private static final Unit send$lambda$1(Function1 $callback, CachedResponse result, Project p) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        $callback.invoke((Object)result);
        return Unit.INSTANCE;
    }
}

