/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.front.dashboard.component.child;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.sheldon.idea.plugin.api.front.dashboard.component.child.JsonEditorPanel;
import com.sheldon.idea.plugin.api.front.dashboard.component.child.JsonExpandedDialog;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u000f\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/sheldon/idea/plugin/api/front/dashboard/component/child/JsonEditorPanel;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "mainTitle", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Ljava/lang/String;)V", "editor", "Lcom/intellij/openapi/editor/Editor;", "setText", "", "text", "getText", "createFormatAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "createClearAction", "createCopyAction", "dispose", "createExpandAction", "idea-plugin"})
public final class JsonEditorPanel
extends JBPanel<JsonEditorPanel>
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private String mainTitle;
    @Nullable
    private Editor editor;

    public JsonEditorPanel(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull String mainTitle) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)mainTitle, (String)"mainTitle");
        super((LayoutManager)new BorderLayout());
        this.project = project;
        this.mainTitle = mainTitle;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document document2 = document;
        this.editor = editorFactory.createEditor(document2, this.project, (FileType)JsonFileType.INSTANCE, false);
        Editor editor = this.editor;
        if (editor != null && (editor = editor.getSettings()) != null) {
            Editor editor2;
            Editor $this$_init__u24lambda_u240 = editor2 = editor;
            boolean bl = false;
            $this$_init__u24lambda_u240.setLineNumbersShown(true);
            $this$_init__u24lambda_u240.setFoldingOutlineShown(true);
            $this$_init__u24lambda_u240.setWhitespacesShown(false);
            $this$_init__u24lambda_u240.setUseSoftWraps(true);
            $this$_init__u24lambda_u240.setAdditionalPageAtBottom(false);
        }
        DefaultActionGroup $this$_init__u24lambda_u241 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$_init__u24lambda_u241.add(this.createFormatAction());
        $this$_init__u24lambda_u241.add(this.createClearAction());
        $this$_init__u24lambda_u241.add((AnAction)new Separator());
        $this$_init__u24lambda_u241.add(this.createCopyAction());
        $this$_init__u24lambda_u241.add(this.createExpandAction(this.mainTitle));
        DefaultActionGroup actionGroup = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JsonEditorToolbar", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)((Object)this));
        JComponent jComponent = actionToolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent toolbarComponent = jComponent;
        toolbarComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JBColor.border()));
        this.add(toolbarComponent, "North");
        Editor editor3 = this.editor;
        Intrinsics.checkNotNull((Object)editor3);
        this.add(editor3.getComponent(), "Center");
        Editor editor4 = this.editor;
        int lineHeight = editor4 != null ? editor4.getLineHeight() : 20;
        int toolbarHeight = toolbarComponent.getPreferredSize().height;
        int targetHeight = toolbarHeight + lineHeight * 2 + 4;
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(100, targetHeight));
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public final void setText(@Nullable String text) {
        String string = text;
        if (string == null) {
            string = "";
        }
        String safeText = string;
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> JsonEditorPanel.setText$lambda$2(this, safeText));
    }

    @NotNull
    public final String getText() {
        Object object = this.editor;
        if (object == null || (object = object.getDocument()) == null || (object = object.getText()) == null) {
            object = "";
        }
        return object;
    }

    private final AnAction createFormatAction() {
        Icon icon = AllIcons.Actions.PrettyPrint;
        return new AnAction(this, icon){
            final /* synthetic */ JsonEditorPanel this$0;
            {
                this.this$0 = $receiver;
                super("\u683c\u5f0f\u5316", "\u683c\u5f0f\u5316 JSON \u5185\u5bb9", $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String currentText = this.this$0.getText();
                if (StringsKt.isBlank((CharSequence)currentText)) {
                    return;
                }
                try {
                    JsonElement jsonElement = JsonParser.parseString((String)currentText);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    String prettyJson = gson.toJson(jsonElement);
                    this.this$0.setText(prettyJson);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private final AnAction createClearAction() {
        Icon icon = AllIcons.Actions.GC;
        return new AnAction(this, icon){
            final /* synthetic */ JsonEditorPanel this$0;
            {
                this.this$0 = $receiver;
                super("\u6e05\u7a7a", "\u6e05\u7a7a\u5185\u5bb9", $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setText("");
            }
        };
    }

    private final AnAction createCopyAction() {
        Icon icon = AllIcons.Actions.Copy;
        return new AnAction(this, icon){
            final /* synthetic */ JsonEditorPanel this$0;
            {
                this.this$0 = $receiver;
                super("\u590d\u5236", "\u590d\u5236\u5185\u5bb9\u5230\u526a\u8d34\u677f", $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String text = this.this$0.getText();
                if (((CharSequence)text).length() > 0) {
                    StringSelection selection = new StringSelection(text);
                    CopyPasteManager.getInstance().setContents((Transferable)selection);
                }
            }
        };
    }

    public void dispose() {
        Editor editor = this.editor;
        if (editor != null) {
            Editor it = editor;
            boolean bl = false;
            if (!it.isDisposed()) {
                EditorFactory.getInstance().releaseEditor(it);
            }
        }
        this.editor = null;
    }

    private final AnAction createExpandAction(String mainTitle) {
        Icon icon = AllIcons.General.ExpandComponent;
        return new AnAction(this, mainTitle, icon){
            final /* synthetic */ JsonEditorPanel this$0;
            final /* synthetic */ String $mainTitle;
            {
                this.this$0 = $receiver;
                this.$mainTitle = $mainTitle;
                super("\u653e\u5927\u67e5\u770b", "\u5728\u5f39\u7a97\u4e2d\u5168\u5c4f\u7f16\u8f91", $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String currentText = this.this$0.getText();
                JsonExpandedDialog dialog = new JsonExpandedDialog(JsonEditorPanel.access$getProject$p(this.this$0), this.$mainTitle, currentText, (Function1<? super String, Unit>)((Function1)arg_0 -> createExpandAction.1.actionPerformed$lambda$0(this.this$0, arg_0)));
                dialog.show();
            }

            private static final Unit actionPerformed$lambda$0(JsonEditorPanel this$0, String newText) {
                Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                this$0.setText(newText);
                return Unit.INSTANCE;
            }
        };
    }

    private static final void setText$lambda$2(JsonEditorPanel this$0, String $safeText) {
        block0: {
            Editor editor = this$0.editor;
            if (editor == null || (editor = editor.getDocument()) == null) break block0;
            editor.setText((CharSequence)$safeText);
        }
    }

    public static final /* synthetic */ Project access$getProject$p(JsonEditorPanel $this) {
        return $this.project;
    }
}

