/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.front.dashboard.component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.ui.JBUI;
import com.sheldon.idea.plugin.api.front.dashboard.component.child.FormDataTablePanel;
import com.sheldon.idea.plugin.api.front.dashboard.component.child.JsonEditorPanel;
import com.sheldon.idea.plugin.api.front.dashboard.component.child.KeyValueTablePanel;
import com.sheldon.idea.plugin.api.front.dashboard.utils.CachedResponse;
import com.sheldon.idea.plugin.api.front.dashboard.utils.MockRequestHelper;
import com.sheldon.idea.plugin.api.front.dashboard.utils.ResponseHelperKt;
import com.sheldon.idea.plugin.api.model.ApiMockRequest;
import com.sheldon.idea.plugin.api.utils.Notifier;
import com.sheldon.idea.plugin.api.utils.ProjectCacheService;
import com.sheldon.idea.plugin.api.utils.ThreadingHelperKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0002J\u001a\u0010*\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010\u000fJ\"\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0/2\u0006\u00100\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u00101\u001a\u00020,J\u0010\u00102\u001a\u00020\t2\u0006\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020\tH\u0002J\u0010\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u000fH\u0002J\u0012\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u000f0\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/sheldon/idea/plugin/api/front/dashboard/component/ApiDebugPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "onClose", "Lkotlin/Function0;", "", "getOnClose", "()Lkotlin/jvm/functions/Function0;", "setOnClose", "(Lkotlin/jvm/functions/Function0;)V", "prefix", "", "moduleName", "urlField", "Ljavax/swing/JTextField;", "methodComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "requestTabPane", "Lcom/intellij/ui/components/JBTabbedPane;", "headerArea", "Lcom/sheldon/idea/plugin/api/front/dashboard/component/child/KeyValueTablePanel;", "paramsArea", "formArea", "Lcom/sheldon/idea/plugin/api/front/dashboard/component/child/FormDataTablePanel;", "jsonArea", "Lcom/sheldon/idea/plugin/api/front/dashboard/component/child/JsonEditorPanel;", "responseTabPane", "respBodyArea", "respHeaderArea", "dispose", "initTabs", "createScrollArea", "Ljavax/swing/JScrollPane;", "textArea", "Ljava/awt/Component;", "buildUi", "Lcom/intellij/openapi/ui/DialogPanel;", "setData", "data", "Lcom/sheldon/idea/plugin/api/model/ApiMockRequest;", "treeModuleName", "splitDomainAndPath", "Lkotlin/Pair;", "url", "getData", "processResponse", "response", "Lcom/sheldon/idea/plugin/api/front/dashboard/utils/CachedResponse;", "prepareAndSend", "extractContentType", "headersJson", "isValidFormData", "", "formData", "", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nApiDebugPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiDebugPanel.kt\ncom/sheldon/idea/plugin/api/front/dashboard/component/ApiDebugPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n295#2,2:284\n*S KotlinDebug\n*F\n+ 1 ApiDebugPanel.kt\ncom/sheldon/idea/plugin/api/front/dashboard/component/ApiDebugPanel\n*L\n269#1:284,2\n*E\n"})
public final class ApiDebugPanel
extends JPanel
implements Disposable {
    @NotNull
    private final Project project;
    @Nullable
    private Function0<Unit> onClose;
    @NotNull
    private String prefix;
    @NotNull
    private String moduleName;
    @NotNull
    private final JTextField urlField;
    @NotNull
    private final ComboBox<String> methodComboBox;
    @NotNull
    private final JBTabbedPane requestTabPane;
    @NotNull
    private final KeyValueTablePanel headerArea;
    @NotNull
    private final KeyValueTablePanel paramsArea;
    @NotNull
    private final FormDataTablePanel formArea;
    @NotNull
    private final JsonEditorPanel jsonArea;
    @NotNull
    private final JBTabbedPane responseTabPane;
    @NotNull
    private final JsonEditorPanel respBodyArea;
    @NotNull
    private final JsonEditorPanel respHeaderArea;

    public ApiDebugPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.prefix = "";
        this.moduleName = "";
        this.urlField = new JTextField();
        Object[] objectArray = new String[]{"GET", "POST", "PUT", "DELETE"};
        this.methodComboBox = new ComboBox(objectArray);
        this.requestTabPane = new JBTabbedPane();
        this.headerArea = new KeyValueTablePanel();
        this.paramsArea = new KeyValueTablePanel();
        this.formArea = new FormDataTablePanel(this.project);
        this.jsonArea = new JsonEditorPanel(this.project, this, "\u8bf7\u6c42Json\u8be6\u60c5");
        this.responseTabPane = new JBTabbedPane();
        this.respBodyArea = new JsonEditorPanel(this.project, this, "\u54cd\u5e94\u8be6\u60c5");
        this.respHeaderArea = new JsonEditorPanel(this.project, this, "\u54cd\u5e94\u5934");
        this.initTabs();
        DialogPanel mainPanel = this.buildUi();
        this.add((Component)mainPanel, "Center");
    }

    @Nullable
    public final Function0<Unit> getOnClose() {
        return this.onClose;
    }

    public final void setOnClose(@Nullable Function0<Unit> function0) {
        this.onClose = function0;
    }

    public void dispose() {
    }

    private final void initTabs() {
        this.requestTabPane.addTab("Headers", (Component)this.createScrollArea(this.headerArea));
        this.requestTabPane.addTab("Params", (Component)this.createScrollArea(this.paramsArea));
        this.requestTabPane.addTab("Form", (Component)this.formArea);
        this.requestTabPane.addTab("Json", (Component)this.createScrollArea((Component)((Object)this.jsonArea)));
        this.responseTabPane.addTab("Body", (Component)this.createScrollArea((Component)((Object)this.respBodyArea)));
        this.responseTabPane.addTab("Headers", (Component)this.createScrollArea((Component)((Object)this.respHeaderArea)));
    }

    private final JScrollPane createScrollArea(Component textArea) {
        JScrollPane jScrollPane;
        JScrollPane $this$createScrollArea_u24lambda_u240 = jScrollPane = new JScrollPane(textArea);
        boolean bl = false;
        $this$createScrollArea_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        return jScrollPane;
    }

    private final DialogPanel buildUi() {
        return BuilderKt.panel(arg_0 -> ApiDebugPanel.buildUi$lambda$13(this, arg_0));
    }

    public final void setData(@Nullable ApiMockRequest data, @Nullable String treeModuleName) {
        if (data == null) {
            return;
        }
        if (treeModuleName == null) {
            return;
        }
        this.prefix = data.getPrefix();
        this.moduleName = treeModuleName;
        this.urlField.setText(data.getPrefix() + data.getPath());
        this.methodComboBox.setSelectedItem((Object)data.getMethod());
        String string = data.getHeaders();
        if (string == null) {
            string = "";
        }
        this.headerArea.setData(string);
        String string2 = data.getQuery();
        if (string2 == null) {
            string2 = "";
        }
        this.paramsArea.setData(string2);
        this.formArea.setData(data.getFormData());
        this.jsonArea.setText(data.getBody());
        this.respBodyArea.setText(data.getResponseBody());
        this.respHeaderArea.setText(data.getResponseHeaders());
    }

    @NotNull
    public final Pair<String, String> splitDomainAndPath(@NotNull String url, @NotNull String prefix) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (((CharSequence)prefix).length() > 0 && StringsKt.startsWith$default((String)url, (String)prefix, (boolean)false, (int)2, null)) {
            String path = StringsKt.removePrefix((String)url, (CharSequence)prefix);
            return TuplesKt.to((Object)prefix, (Object)(((CharSequence)path).length() == 0 ? "/" : path));
        }
        try {
            URI uri = new URI(url);
            String domain = uri.getScheme() + "://" + uri.getAuthority();
            String string = uri.getRawPath();
            if (string == null) {
                string = "";
            }
            String path = string;
            pair = ((CharSequence)domain).length() > 0 ? TuplesKt.to((Object)domain, (Object)(((CharSequence)path).length() == 0 ? "/" : path)) : TuplesKt.to((Object)"", (Object)url);
        }
        catch (Exception e) {
            pair = TuplesKt.to((Object)"", (Object)url);
        }
        return pair;
    }

    @NotNull
    public final ApiMockRequest getData() {
        String string = this.urlField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Pair<String, String> pair = this.splitDomainAndPath(string, this.prefix);
        String domain = (String)pair.component1();
        String path = (String)pair.component2();
        Object object = this.methodComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String string2 = (String)object;
        String string3 = this.headerArea.getData();
        String string4 = this.paramsArea.getData();
        String string5 = this.formArea.getData();
        String string6 = this.jsonArea.getText();
        String string7 = this.respBodyArea.getText();
        String string8 = this.respHeaderArea.getText();
        return new ApiMockRequest(path, string2, string3, string4, null, string6, string5, domain, string7, string8, 16, null);
    }

    private final void processResponse(CachedResponse response) {
        ResponseHelperKt.handleResponse(this.project, response, (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> ApiDebugPanel.processResponse$lambda$14(this, arg_0, arg_1)));
    }

    private final void prepareAndSend() {
        String string;
        ApiMockRequest requestData;
        block18: {
            block17: {
                requestData = this.getData();
                System.out.println((Object)("requestData:" + requestData));
                boolean bl = this.isValidFormData(requestData.getFormData());
                System.out.println(bl);
                string = requestData.getMethod();
                if (string == null) break block17;
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                string = string2;
                if (string2 != null) break block18;
            }
            string = "GET";
        }
        String method = string;
        String finalBodyType = null;
        String finalBodyContent = null;
        if (!Intrinsics.areEqual((Object)method, (Object)"POST")) {
            System.out.println((Object)("Sending " + method + " request without body check..."));
            String string3 = this.urlField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            MockRequestHelper.INSTANCE.send(this.project, requestData, string3, "", (Function1<? super CachedResponse, Unit>)((Function1)arg_0 -> ApiDebugPanel.prepareAndSend$lambda$15(this, arg_0)));
            return;
        }
        String string4 = requestData.getHeaders();
        if (string4 == null) {
            string4 = "{}";
        }
        String headersStr = string4;
        String activeTabTitle = this.requestTabPane.getTitleAt(this.requestTabPane.getSelectedIndex());
        System.out.println((Object)("activeTabTitle:" + activeTabTitle));
        String contentTypeHeader = this.extractContentType(headersStr);
        System.out.println((Object)("contentTypeHeader:" + contentTypeHeader));
        boolean isJsonHeader = StringsKt.contains((CharSequence)contentTypeHeader, (CharSequence)"application/json", (boolean)true);
        boolean isFormHeader = StringsKt.contains((CharSequence)contentTypeHeader, (CharSequence)"multipart/form-data", (boolean)true);
        boolean isJsonTab = Intrinsics.areEqual((Object)activeTabTitle, (Object)"Json");
        boolean isFormTab = Intrinsics.areEqual((Object)activeTabTitle, (Object)"Form");
        if (isJsonHeader) {
            finalBodyType = "application/json";
            finalBodyContent = requestData.getBody();
        } else if (isFormHeader) {
            finalBodyType = "multipart/form-data";
            finalBodyContent = requestData.getFormData();
        } else if (isJsonTab) {
            finalBodyType = "application/json";
            finalBodyContent = requestData.getBody();
        } else if (isFormTab) {
            finalBodyType = "multipart/form-data";
            finalBodyContent = requestData.getFormData();
        } else {
            boolean hasJsonContent = !StringsKt.isBlank((CharSequence)requestData.getBody()) && !Intrinsics.areEqual((Object)requestData.getBody(), (Object)"{}");
            boolean hasFormContent = this.isValidFormData(requestData.getFormData());
            if (hasJsonContent) {
                finalBodyType = "application/json";
                finalBodyContent = requestData.getBody();
            } else if (hasFormContent) {
                finalBodyType = "multipart/form-data";
                finalBodyContent = requestData.getFormData();
            } else {
                finalBodyType = null;
            }
        }
        System.out.println((Object)"=== Send Request Preparation ===");
        System.out.println((Object)("Method: " + method));
        System.out.println((Object)("Resolved Body Type: " + finalBodyType));
        System.out.println((Object)("Body Content: " + finalBodyContent));
        String string5 = this.urlField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        MockRequestHelper.INSTANCE.send(this.project, requestData, string5, finalBodyType, (Function1<? super CachedResponse, Unit>)((Function1)arg_0 -> ApiDebugPanel.prepareAndSend$lambda$16(this, arg_0)));
    }

    private final String extractContentType(String headersJson) {
        try {
            Object object;
            Object v1;
            block5: {
                if (StringsKt.isBlank((CharSequence)headersJson)) {
                    return "";
                }
                Type type2 = new TypeToken<Map<String, ? extends String>>(){}.getType();
                Object object2 = new Gson().fromJson(headersJson, type2);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
                Map headersMap = (Map)object2;
                Iterable $this$firstOrNull$iv = headersMap.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)((String)it.getKey()), (String)"content-type", (boolean)true)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            if ((object = (Map.Entry)v1) == null || (object = (String)object.getValue()) == null) {
                object = "";
            }
            return object;
        }
        catch (Exception e) {
            return "";
        }
    }

    private final boolean isValidFormData(Object formData) {
        if (formData == null) {
            return false;
        }
        return !Intrinsics.areEqual((Object)formData, (Object)"{}");
    }

    private static final Unit buildUi$lambda$13$lambda$1(ApiDebugPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.urlField).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$10$lambda$2(ApiDebugPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.prepareAndSend();
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$10$lambda$3(JButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setIcon(AllIcons.Actions.Execute);
        return Unit.INSTANCE;
    }

    private static final String buildUi$lambda$13$lambda$10$lambda$6$lambda$4(ApiDebugPanel this$0, ApiMockRequest $changeMockData, Project p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        ProjectCacheService cacheService = ProjectCacheService.Companion.getInstance(p);
        String string = this$0.moduleName;
        String string2 = $changeMockData.getMethod();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return cacheService.saveOrUpdateSingleRequestMock(string, string3 + ":" + $changeMockData.getPath(), $changeMockData);
    }

    private static final Unit buildUi$lambda$13$lambda$10$lambda$6$lambda$5(String string, Project p) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Notifier.notifyInfo$default(Notifier.INSTANCE, p, null, "\u4fdd\u5b58\u6210\u529f", 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$10$lambda$6(ApiDebugPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ApiMockRequest changeMockData = this$0.getData();
        ThreadingHelperKt.runBackgroundReadUI$default(ThreadingHelperKt.context(this$0.project), "AST_CALLER_GLOBAL_ACTION", false, arg_0 -> ApiDebugPanel.buildUi$lambda$13$lambda$10$lambda$6$lambda$4(this$0, changeMockData, arg_0), ApiDebugPanel::buildUi$lambda$13$lambda$10$lambda$6$lambda$5, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$10$lambda$7(JButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setIcon(AllIcons.Actions.MenuSaveall);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$10$lambda$8(ApiDebugPanel this$0, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Function0<Unit> function0 = this$0.onClose;
            if (function0 == null) break block0;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$10$lambda$9(JButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setIcon(AllIcons.Actions.Cancel);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$10(ApiDebugPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.methodComboBox).gap(RightGap.SMALL);
        $this$row.button("\u53d1\u9001", arg_0 -> ApiDebugPanel.buildUi$lambda$13$lambda$10$lambda$2(this$0, arg_0)).applyToComponent(ApiDebugPanel::buildUi$lambda$13$lambda$10$lambda$3);
        $this$row.button("\u4fdd\u5b58", arg_0 -> ApiDebugPanel.buildUi$lambda$13$lambda$10$lambda$6(this$0, arg_0)).applyToComponent(ApiDebugPanel::buildUi$lambda$13$lambda$10$lambda$7);
        $this$row.button("\u5173\u95ed", arg_0 -> ApiDebugPanel.buildUi$lambda$13$lambda$10$lambda$8(this$0, arg_0)).applyToComponent(ApiDebugPanel::buildUi$lambda$13$lambda$10$lambda$9);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$11(ApiDebugPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.requestTabPane).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13$lambda$12(ApiDebugPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.responseTabPane).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit buildUi$lambda$13(ApiDebugPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row("", arg_0 -> ApiDebugPanel.buildUi$lambda$13$lambda$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ApiDebugPanel.buildUi$lambda$13$lambda$10(this$0, arg_0), (int)1, null).layout(RowLayout.INDEPENDENT);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ApiDebugPanel.buildUi$lambda$13$lambda$11(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ApiDebugPanel.buildUi$lambda$13$lambda$12(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit processResponse$lambda$14(ApiDebugPanel this$0, String headersContent, String bodyContent) {
        Intrinsics.checkNotNullParameter((Object)headersContent, (String)"headersContent");
        Intrinsics.checkNotNullParameter((Object)bodyContent, (String)"bodyContent");
        this$0.respBodyArea.setText(bodyContent);
        this$0.respHeaderArea.setText(headersContent);
        return Unit.INSTANCE;
    }

    private static final Unit prepareAndSend$lambda$15(ApiDebugPanel this$0, CachedResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.processResponse(it);
        return Unit.INSTANCE;
    }

    private static final Unit prepareAndSend$lambda$16(ApiDebugPanel this$0, CachedResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.processResponse(it);
        return Unit.INSTANCE;
    }
}

