/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.front.dashboard;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.rd.util.CollectionExKt;
import com.sheldon.idea.plugin.api.front.dashboard.component.ApiDebugPanel;
import com.sheldon.idea.plugin.api.front.dashboard.component.ApiTreePanel;
import com.sheldon.idea.plugin.api.front.dashboard.component.ModuleSelector;
import com.sheldon.idea.plugin.api.front.dashboard.utils.TreeAction;
import com.sheldon.idea.plugin.api.model.ApiMockRequest;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.utils.Notifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/sheldon/idea/plugin/api/front/dashboard/ApiDashboardToolWindow;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "ApiDashboardPanel", "idea-plugin"})
public final class ApiDashboardToolWindow
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ApiDashboardPanel dashboardPanel = new ApiDashboardPanel(project);
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content = contentFactory.createContent(dashboardPanel.getContent(), "\u63a5\u53e3", true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        toolWindow.getContentManager().addContent(content2);
        DumbService.getInstance((Project)project).runWhenSmart(() -> ApiDashboardToolWindow.createToolWindowContent$lambda$0(dashboardPanel));
    }

    private static final void createToolWindowContent$lambda$0(ApiDashboardPanel $dashboardPanel) {
        $dashboardPanel.loadData(false);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/sheldon/idea/plugin/api/front/dashboard/ApiDashboardToolWindow$ApiDashboardPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "treePanel", "Lcom/sheldon/idea/plugin/api/front/dashboard/component/ApiTreePanel;", "getTreePanel", "()Lcom/sheldon/idea/plugin/api/front/dashboard/component/ApiTreePanel;", "moduleSelector", "Lcom/sheldon/idea/plugin/api/front/dashboard/component/ModuleSelector;", "getModuleSelector", "()Lcom/sheldon/idea/plugin/api/front/dashboard/component/ModuleSelector;", "debugPanel", "Lcom/sheldon/idea/plugin/api/front/dashboard/component/ApiDebugPanel;", "getDebugPanel", "()Lcom/sheldon/idea/plugin/api/front/dashboard/component/ApiDebugPanel;", "refreshButton", "Ljavax/swing/JButton;", "getContent", "Ljavax/swing/JComponent;", "loadData", "", "isForceRefresh", "", "idea-plugin"})
    public static final class ApiDashboardPanel {
        @NotNull
        private final Project project;
        @NotNull
        private final ApiTreePanel treePanel;
        @NotNull
        private final ModuleSelector moduleSelector;
        @NotNull
        private final ApiDebugPanel debugPanel;
        @Nullable
        private JButton refreshButton;

        public ApiDashboardPanel(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.treePanel = new ApiTreePanel(this.project);
            this.moduleSelector = new ModuleSelector(this.project, this.treePanel);
            this.debugPanel = new ApiDebugPanel(this.project);
        }

        @NotNull
        public final ApiTreePanel getTreePanel() {
            return this.treePanel;
        }

        @NotNull
        public final ModuleSelector getModuleSelector() {
            return this.moduleSelector;
        }

        @NotNull
        public final ApiDebugPanel getDebugPanel() {
            return this.debugPanel;
        }

        @NotNull
        public final JComponent getContent() {
            DialogPanel dialogPanel;
            DialogPanel $this$getContent_u24lambda_u244 = dialogPanel = BuilderKt.panel(arg_0 -> ApiDashboardPanel.getContent$lambda$3(this, arg_0));
            boolean bl = false;
            $this$getContent_u24lambda_u244.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            DialogPanel topBar = dialogPanel;
            JBSplitter splitter = new JBSplitter(true, 0.6f);
            splitter.setFirstComponent((JComponent)((Object)this.treePanel));
            splitter.setSecondComponent(null);
            this.debugPanel.setOnClose((Function0<Unit>)((Function0)() -> ApiDashboardPanel.getContent$lambda$5(splitter)));
            this.treePanel.setOnCloseMock((Function0<Unit>)((Function0)() -> ApiDashboardPanel.getContent$lambda$6(splitter)));
            this.treePanel.setOnNodeSelected((Function2<? super ApiMockRequest, ? super String, Unit>)((Function2)(arg_0, arg_1) -> ApiDashboardPanel.getContent$lambda$7(splitter, this, arg_0, arg_1)));
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)topBar, "North");
            mainPanel.add((Component)splitter, "Center");
            return mainPanel;
        }

        public final void loadData(boolean isForceRefresh) {
            if (DumbService.isDumb((Project)this.project)) {
                Notifier.notifyWarning$default(Notifier.INSTANCE, this.project, null, "\u7d22\u5f15\u6b63\u5728\u6784\u5efa\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0", 2, null);
                return;
            }
            JButton jButton = this.refreshButton;
            if (jButton != null) {
                JButton it = jButton;
                boolean bl = false;
                it.setIcon((Icon)new AnimatedIcon.Default());
                it.setEnabled(false);
            }
            TreeAction.INSTANCE.reloadTree(this.project, isForceRefresh, (Function2<? super Map<String, ApiNode>, ? super Project, Unit>)((Function2)(arg_0, arg_1) -> ApiDashboardPanel.loadData$lambda$10(this, arg_0, arg_1)));
        }

        private static final Unit getContent$lambda$3$lambda$2$lambda$0(ApiDashboardPanel this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.loadData(true);
            return Unit.INSTANCE;
        }

        private static final Unit getContent$lambda$3$lambda$2$lambda$1(ApiDashboardPanel this$0, JButton $this$applyToComponent) {
            Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
            this$0.refreshButton = $this$applyToComponent;
            $this$applyToComponent.setIcon(AllIcons.Actions.Refresh);
            $this$applyToComponent.setToolTipText("\u5237\u65b0\u6240\u6709\u670d\u52a1");
            $this$applyToComponent.setContentAreaFilled(false);
            return Unit.INSTANCE;
        }

        private static final Unit getContent$lambda$3$lambda$2(ApiDashboardPanel this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.button("", arg_0 -> ApiDashboardPanel.getContent$lambda$3$lambda$2$lambda$0(this$0, arg_0)).applyToComponent(arg_0 -> ApiDashboardPanel.getContent$lambda$3$lambda$2$lambda$1(this$0, arg_0));
            $this$row.cell((JComponent)((Object)this$0.moduleSelector)).align(Align.FILL);
            return Unit.INSTANCE;
        }

        private static final Unit getContent$lambda$3(ApiDashboardPanel this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> ApiDashboardPanel.getContent$lambda$3$lambda$2(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit getContent$lambda$5(JBSplitter $splitter) {
            $splitter.setSecondComponent(null);
            return Unit.INSTANCE;
        }

        private static final Unit getContent$lambda$6(JBSplitter $splitter) {
            $splitter.setSecondComponent(null);
            return Unit.INSTANCE;
        }

        private static final Unit getContent$lambda$7(JBSplitter $splitter, ApiDashboardPanel this$0, ApiMockRequest mockRequest, String moduleName) {
            if ($splitter.getSecondComponent() == null) {
                $splitter.setSecondComponent((JComponent)this$0.debugPanel);
            }
            this$0.debugPanel.setData(mockRequest, moduleName);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit loadData$lambda$10(ApiDashboardPanel this$0, Map treeMap, Project project) {
            Intrinsics.checkNotNullParameter((Object)treeMap, (String)"treeMap");
            Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
            try {
                if (treeMap.isEmpty()) {
                    Notifier.notifyWarning$default(Notifier.INSTANCE, this$0.project, null, "\u672a\u626b\u63cf\u5230\u63a5\u53e3\uff0c\u8bf7\u786e\u8ba4\u5de5\u7a0b\u7ed3\u6784\u662f\u5426\u6b63\u786e", 2, null);
                } else {
                    ApiNode rootNode = (ApiNode)CollectionExKt.first((Map)treeMap).getValue();
                    this$0.treePanel.renderApiTree(rootNode);
                    this$0.moduleSelector.updateDropdown(treeMap.keySet());
                    this$0.moduleSelector.setEditable(true);
                }
            }
            finally {
                JButton jButton = this$0.refreshButton;
                if (jButton != null) {
                    JButton it = jButton;
                    boolean bl = false;
                    it.setIcon(AllIcons.Actions.Refresh);
                    it.setEnabled(true);
                }
            }
            return Unit.INSTANCE;
        }
    }
}

