/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.resolver.method.parameter;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.sheldon.idea.plugin.api.method.ParamLocation;
import com.sheldon.idea.plugin.api.utils.build.ParamAnalysisResult;
import com.sheldon.idea.plugin.api.utils.build.resolver.method.parameter.MethodParameterResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/method/parameter/SimpleTypeResolver;", "Lcom/sheldon/idea/plugin/api/utils/build/resolver/method/parameter/MethodParameterResolver;", "<init>", "()V", "resolve", "Lcom/sheldon/idea/plugin/api/utils/build/ParamAnalysisResult;", "parameter", "Lcom/intellij/psi/PsiParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "isSimpleType", "", "type", "Lcom/intellij/psi/PsiType;", "isWhitelistedSimpleType", "qName", "", "isWrapperOrNumber", "isCollection", "idea-plugin"})
public final class SimpleTypeResolver
implements MethodParameterResolver {
    @Override
    @Nullable
    public ParamAnalysisResult resolve(@NotNull PsiParameter parameter, @NotNull PsiMethod method, @NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        PsiType psiType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        if (this.isSimpleType(psiType)) {
            ParamLocation paramLocation = ParamLocation.QUERY;
            String string = parameter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            PsiType psiType2 = parameter.getType();
            return new ParamAnalysisResult(paramLocation, string2, true, psiType2, null, 16, null);
        }
        return null;
    }

    public final boolean isSimpleType(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2 instanceof PsiPrimitiveType) {
            return true;
        }
        if (type2 instanceof PsiArrayType) {
            PsiType psiType = ((PsiArrayType)type2).getComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getComponentType(...)");
            return this.isSimpleType(psiType);
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        String string = psiClass2.getQualifiedName();
        if (string == null) {
            return false;
        }
        String qName = string;
        if (this.isCollection(qName)) {
            PsiType itemType = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false);
            return itemType != null ? this.isSimpleType(itemType) : true;
        }
        if (psiClass2.isEnum()) {
            return true;
        }
        return this.isWhitelistedSimpleType(qName);
    }

    private final boolean isWhitelistedSimpleType(String qName) {
        return Intrinsics.areEqual((Object)qName, (Object)"java.lang.String") ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.lang.CharSequence") ? true : (StringsKt.startsWith$default((String)qName, (String)"java.lang.", (boolean)false, (int)2, null) && this.isWrapperOrNumber(qName) ? true : (StringsKt.startsWith$default((String)qName, (String)"java.math.", (boolean)false, (int)2, null) ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.util.Date") ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.sql.Date") ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.sql.Timestamp") ? true : (StringsKt.startsWith$default((String)qName, (String)"java.time.", (boolean)false, (int)2, null) ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.util.UUID") ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.util.Currency") ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.util.Locale") ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.net.URI") ? true : (Intrinsics.areEqual((Object)qName, (Object)"java.net.URL") ? true : Intrinsics.areEqual((Object)qName, (Object)"java.nio.charset.Charset")))))))))))));
    }

    private final boolean isWrapperOrNumber(String qName) {
        return Intrinsics.areEqual((Object)qName, (Object)"java.lang.Boolean") || Intrinsics.areEqual((Object)qName, (Object)"java.lang.Character") || Intrinsics.areEqual((Object)qName, (Object)"java.lang.Byte") || Intrinsics.areEqual((Object)qName, (Object)"java.lang.Short") || Intrinsics.areEqual((Object)qName, (Object)"java.lang.Integer") || Intrinsics.areEqual((Object)qName, (Object)"java.lang.Long") || Intrinsics.areEqual((Object)qName, (Object)"java.lang.Float") || Intrinsics.areEqual((Object)qName, (Object)"java.lang.Double") || Intrinsics.areEqual((Object)qName, (Object)"java.lang.Number");
    }

    private final boolean isCollection(String qName) {
        return Intrinsics.areEqual((Object)qName, (Object)"java.util.Collection") || Intrinsics.areEqual((Object)qName, (Object)"java.util.List") || Intrinsics.areEqual((Object)qName, (Object)"java.util.Set") || Intrinsics.areEqual((Object)qName, (Object)"java.util.ArrayList") || Intrinsics.areEqual((Object)qName, (Object)"java.util.LinkedList") || Intrinsics.areEqual((Object)qName, (Object)"java.util.HashSet");
    }
}

