/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.resolver.method.parameter;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.sheldon.idea.plugin.api.method.ParamLocation;
import com.sheldon.idea.plugin.api.utils.TypeUtils;
import com.sheldon.idea.plugin.api.utils.build.ParamAnalysisResult;
import com.sheldon.idea.plugin.api.utils.build.resolver.ResolverHelper;
import com.sheldon.idea.plugin.api.utils.build.resolver.method.parameter.MethodParameterResolver;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/method/parameter/AnnotatedParameterResolver;", "Lcom/sheldon/idea/plugin/api/utils/build/resolver/method/parameter/MethodParameterResolver;", "<init>", "()V", "resolve", "Lcom/sheldon/idea/plugin/api/utils/build/ParamAnalysisResult;", "parameter", "Lcom/intellij/psi/PsiParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "isHeaderContainer", "", "type", "Lcom/intellij/psi/PsiType;", "extractBasicInfo", "Lcom/sheldon/idea/plugin/api/utils/build/resolver/method/parameter/AnnotatedParameterResolver$BasicInfo;", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "getBooleanAttribute", "name", "", "defaultVal", "BasicInfo", "idea-plugin"})
public final class AnnotatedParameterResolver
implements MethodParameterResolver {
    @Override
    @Nullable
    public ParamAnalysisResult resolve(@NotNull PsiParameter parameter, @NotNull PsiMethod method, @NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        PsiAnnotation requestBody = parameter.getAnnotation("org.springframework.web.bind.annotation.RequestBody");
        PsiType psiType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType realType = TypeUtils.INSTANCE.getRealTypeForMethod(method, psiType, psiClass);
        if (requestBody != null) {
            boolean isRequired = this.getBooleanAttribute(requestBody, "required", true);
            ParamLocation paramLocation = ParamLocation.BODY;
            return new ParamAnalysisResult(paramLocation, "", isRequired, realType, null, 16, null);
        }
        PsiAnnotation requestHeader = parameter.getAnnotation("org.springframework.web.bind.annotation.RequestHeader");
        if (requestHeader != null) {
            if (this.isHeaderContainer(realType)) {
                return null;
            }
            BasicInfo info = this.extractBasicInfo(requestHeader, parameter);
            ParamLocation paramLocation = ParamLocation.HEADER;
            String string = info.getName();
            boolean bl = info.getRequired();
            String string2 = info.getDefaultValue();
            return new ParamAnalysisResult(paramLocation, string, bl, realType, string2);
        }
        PsiAnnotation cookieValue = parameter.getAnnotation("org.springframework.web.bind.annotation.CookieValue");
        if (cookieValue != null) {
            BasicInfo info = this.extractBasicInfo(cookieValue, parameter);
            ParamLocation paramLocation = ParamLocation.HEADER;
            String string = info.getName();
            boolean bl = info.getRequired();
            String string3 = info.getDefaultValue();
            return new ParamAnalysisResult(paramLocation, string, bl, realType, string3);
        }
        PsiAnnotation requestParam = parameter.getAnnotation("org.springframework.web.bind.annotation.RequestParam");
        if (requestParam != null) {
            BasicInfo info = this.extractBasicInfo(requestParam, parameter);
            boolean isFile = ResolverHelper.Companion.isMultipartFile(realType);
            ParamLocation location = isFile ? ParamLocation.FORM_DATA : ParamLocation.QUERY;
            String string = info.getName();
            boolean bl = info.getRequired();
            String string4 = info.getDefaultValue();
            return new ParamAnalysisResult(location, string, bl, realType, string4);
        }
        PsiAnnotation requestPart = parameter.getAnnotation("org.springframework.web.bind.annotation.RequestPart");
        if (requestPart != null) {
            BasicInfo info = this.extractBasicInfo(requestPart, parameter);
            ParamLocation location = ParamLocation.FORM_DATA;
            String string = info.getName();
            boolean bl = info.getRequired();
            return new ParamAnalysisResult(location, string, bl, realType, null, 16, null);
        }
        PsiAnnotation modelAttribute = parameter.getAnnotation("org.springframework.web.bind.annotation.ModelAttribute");
        boolean isFile = ResolverHelper.Companion.isMultipartFile(realType);
        if (isFile) {
            return null;
        }
        if (modelAttribute != null) {
            ParamLocation paramLocation = ParamLocation.QUERY;
            String string = parameter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string5 = string;
            return new ParamAnalysisResult(paramLocation, string5, false, realType, null, 16, null);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHeaderContainer(PsiType type2) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        String string = psiClass2.getQualifiedName();
        if (string == null) {
            return false;
        }
        String qName = string;
        switch (qName.hashCode()) {
            case 7930079: {
                if (qName.equals("org.springframework.http.HttpHeaders")) return true;
                return InheritanceUtil.isInheritor((PsiType)type2, (String)"org.springframework.http.HttpHeaders") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiType)type2, (String)"org.springframework.util.MultiValueMap");
            }
            case -1383349348: {
                if (qName.equals("java.util.Map")) return true;
                return InheritanceUtil.isInheritor((PsiType)type2, (String)"org.springframework.http.HttpHeaders") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiType)type2, (String)"org.springframework.util.MultiValueMap");
            }
            case -1739193537: {
                if (!qName.equals("org.springframework.util.MultiValueMap")) return InheritanceUtil.isInheritor((PsiType)type2, (String)"org.springframework.http.HttpHeaders") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiType)type2, (String)"org.springframework.util.MultiValueMap");
                return true;
            }
        }
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"org.springframework.http.HttpHeaders") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiType)type2, (String)"org.springframework.util.MultiValueMap");
    }

    private final BasicInfo extractBasicInfo(PsiAnnotation annotation, PsiParameter parameter) {
        String name = (String)CollectionsKt.firstOrNull(ResolverHelper.Companion.getAnnotationAttributeValues(annotation, "value"));
        if (name == null) {
            name = (String)CollectionsKt.firstOrNull(ResolverHelper.Companion.getAnnotationAttributeValues(annotation, "name"));
        }
        if (name == null) {
            name = parameter.getName();
        }
        boolean required = this.getBooleanAttribute(annotation, "required", true);
        String defaultValue = (String)CollectionsKt.firstOrNull(ResolverHelper.Companion.getAnnotationAttributeValues(annotation, "defaultValue"));
        if (Intrinsics.areEqual((Object)defaultValue, (Object)"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            defaultValue = null;
        }
        return new BasicInfo(name, required, defaultValue);
    }

    private final boolean getBooleanAttribute(PsiAnnotation annotation, String name, boolean defaultVal) {
        PsiAnnotationMemberValue psiAnnotationMemberValue = annotation.findAttributeValue(name);
        if (psiAnnotationMemberValue == null) {
            return defaultVal;
        }
        PsiAnnotationMemberValue value = psiAnnotationMemberValue;
        if (Intrinsics.areEqual((Object)value.getText(), (Object)"true")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)value.getText(), (Object)"false")) {
            return false;
        }
        return defaultVal;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/method/parameter/AnnotatedParameterResolver$BasicInfo;", "", "name", "", "required", "", "defaultValue", "<init>", "(Ljava/lang/String;ZLjava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRequired", "()Z", "getDefaultValue", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "idea-plugin"})
    public static final class BasicInfo {
        @NotNull
        private final String name;
        private final boolean required;
        @Nullable
        private final String defaultValue;

        public BasicInfo(@NotNull String name, boolean required, @Nullable String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.required = required;
            this.defaultValue = defaultValue;
        }

        public /* synthetic */ BasicInfo(String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, bl, string2);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean getRequired() {
            return this.required;
        }

        @Nullable
        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.required;
        }

        @Nullable
        public final String component3() {
            return this.defaultValue;
        }

        @NotNull
        public final BasicInfo copy(@NotNull String name, boolean required, @Nullable String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new BasicInfo(name, required, defaultValue);
        }

        public static /* synthetic */ BasicInfo copy$default(BasicInfo basicInfo, String string, boolean bl, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = basicInfo.name;
            }
            if ((n & 2) != 0) {
                bl = basicInfo.required;
            }
            if ((n & 4) != 0) {
                string2 = basicInfo.defaultValue;
            }
            return basicInfo.copy(string, bl, string2);
        }

        @NotNull
        public String toString() {
            return "BasicInfo(name=" + this.name + ", required=" + this.required + ", defaultValue=" + this.defaultValue + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Boolean.hashCode(this.required);
            result = result * 31 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BasicInfo)) {
                return false;
            }
            BasicInfo basicInfo = (BasicInfo)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)basicInfo.name)) {
                return false;
            }
            if (this.required != basicInfo.required) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.defaultValue, (Object)basicInfo.defaultValue);
        }
    }
}

