/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build.resolver;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ \u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J.\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u0014\u001a\u00020\u0013J(\u0010\u0015\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0002JF\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/resolver/AnnotationResolver;", "", "<init>", "()V", "resolveForClass", "Lcom/intellij/psi/PsiAnnotation;", "psiClass", "Lcom/intellij/psi/PsiClass;", "targetAnnotations", "", "", "resolveForElement", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "findRecursively", "annotation", "visited", "", "hasAnnotations", "", "findAll", "hasTargetAnnotation", "isMetaAnnotated", "foundSoFar", "idea-plugin"})
public final class AnnotationResolver {
    @NotNull
    public static final AnnotationResolver INSTANCE = new AnnotationResolver();

    private AnnotationResolver() {
    }

    @Nullable
    public final PsiAnnotation resolveForClass(@NotNull PsiClass psiClass, @NotNull Collection<String> targetAnnotations) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter(targetAnnotations, (String)"targetAnnotations");
        for (PsiClass currentClass = psiClass; currentClass != null && !Intrinsics.areEqual((Object)currentClass.getQualifiedName(), (Object)"java.lang.Object"); currentClass = currentClass.getSuperClass()) {
            PsiAnnotation found = this.resolveForElement((PsiModifierListOwner)currentClass, targetAnnotations);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private final PsiAnnotation resolveForElement(PsiModifierListOwner owner, Collection<String> targetAnnotations) {
        Set visited = new LinkedHashSet();
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            Intrinsics.checkNotNull((Object)annotation);
            PsiAnnotation found = this.findRecursively(annotation, visited, targetAnnotations);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private final PsiAnnotation findRecursively(PsiAnnotation annotation, Set<String> visited, Collection<String> targetAnnotations) {
        String string = annotation.getQualifiedName();
        if (string == null) {
            return null;
        }
        String qName = string;
        if (targetAnnotations.contains(qName)) {
            return annotation;
        }
        if (!visited.add(qName)) {
            return null;
        }
        if (StringsKt.startsWith$default((String)qName, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qName, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qName, (String)"javax.", (boolean)false, (int)2, null)) {
            return null;
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
        PsiElement psiElement = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return null;
        }
        PsiClass annotationClass = psiClass;
        for (PsiAnnotation metaAnnotation : annotationClass.getAnnotations()) {
            Intrinsics.checkNotNull((Object)metaAnnotation);
            PsiAnnotation found = this.findRecursively(metaAnnotation, visited, targetAnnotations);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public final boolean hasAnnotations(@NotNull PsiClass psiClass, @NotNull Collection<String> targetAnnotations, boolean findAll) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter(targetAnnotations, (String)"targetAnnotations");
        for (PsiClass currentClass = psiClass; currentClass != null && !Intrinsics.areEqual((Object)currentClass.getQualifiedName(), (Object)"java.lang.Object"); currentClass = currentClass.getSuperClass()) {
            if (!this.hasTargetAnnotation((PsiModifierListOwner)currentClass, targetAnnotations, findAll)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean hasAnnotations$default(AnnotationResolver annotationResolver, PsiClass psiClass, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return annotationResolver.hasAnnotations(psiClass, collection, bl);
    }

    private final boolean hasTargetAnnotation(PsiModifierListOwner owner, Collection<String> targetAnnotations, boolean findAll) {
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            Intrinsics.checkNotNull((Object)annotation);
            if (!AnnotationResolver.isMetaAnnotated$default(this, annotation, new LinkedHashSet(), targetAnnotations, findAll, null, 16, null)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean hasTargetAnnotation$default(AnnotationResolver annotationResolver, PsiModifierListOwner psiModifierListOwner, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return annotationResolver.hasTargetAnnotation(psiModifierListOwner, collection, bl);
    }

    private final boolean isMetaAnnotated(PsiAnnotation annotation, Set<String> visited, Collection<String> targetAnnotations, boolean findAll, Set<String> foundSoFar) {
        String string = annotation.getQualifiedName();
        if (string == null) {
            return false;
        }
        String qName = string;
        if (targetAnnotations.contains(qName)) {
            foundSoFar.add(qName);
        }
        if (findAll ? foundSoFar.containsAll(targetAnnotations) : !((Collection)foundSoFar).isEmpty()) {
            return true;
        }
        if (!visited.add(qName)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)qName, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qName, (String)"kotlin.", (boolean)false, (int)2, null)) {
            return false;
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
        PsiElement psiElement = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return false;
        }
        PsiClass annotationClass = psiClass;
        for (PsiAnnotation metaAnnotation : annotationClass.getAnnotations()) {
            Intrinsics.checkNotNull((Object)metaAnnotation);
            if (!this.isMetaAnnotated(metaAnnotation, visited, targetAnnotations, findAll, foundSoFar)) continue;
            return true;
        }
        return findAll && foundSoFar.containsAll(targetAnnotations);
    }

    static /* synthetic */ boolean isMetaAnnotated$default(AnnotationResolver annotationResolver, PsiAnnotation psiAnnotation, Set set, Collection collection, boolean bl, Set set2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            set2 = new LinkedHashSet();
        }
        return annotationResolver.isMetaAnnotated(psiAnnotation, set, collection, bl, set2);
    }
}

