/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.model.ChildNodeType;
import com.sheldon.idea.plugin.api.model.CodeType;
import com.sheldon.idea.plugin.api.model.NodeType;
import com.sheldon.idea.plugin.api.service.SpringClassName;
import com.sheldon.idea.plugin.api.utils.HashUtilsKt;
import com.sheldon.idea.plugin.api.utils.PathUtils;
import com.sheldon.idea.plugin.api.utils.build.helper.ClassHelper;
import com.sheldon.idea.plugin.api.utils.build.helper.MethodHelper;
import com.sheldon.idea.plugin.api.utils.build.resolver.AnnotationResolver;
import com.sheldon.idea.plugin.api.utils.build.resolver.SpringClassResolver;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015JB\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000f2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00150 J(\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000f\u00a8\u0006#"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/TreeBuilder;", "", "<init>", "()V", "findBasePackageDirectory", "Lcom/intellij/psi/PsiDirectory;", "dir", "isController", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "isMappingMethod", "method", "Lcom/intellij/psi/PsiMethod;", "makeRootNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "module", "Lcom/intellij/openapi/module/Module;", "makeDirNode", "subDir", "parentPath", "", "makeClassNode", "classHelper", "Lcom/sheldon/idea/plugin/api/utils/build/helper/ClassHelper;", "makeMethodNode", "methodHelper", "Lcom/sheldon/idea/plugin/api/utils/build/helper/MethodHelper;", "psiMethod", "prefixPath", "classNode", "callback", "Lkotlin/Function2;", "Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "makeMethodExcludeParam", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nbase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 base.kt\ncom/sheldon/idea/plugin/api/utils/build/TreeBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n12567#2,2:204\n1755#3,3:206\n*S KotlinDebug\n*F\n+ 1 base.kt\ncom/sheldon/idea/plugin/api/utils/build/TreeBuilder\n*L\n29#1:204,2\n51#1:206,3\n*E\n"})
public abstract class TreeBuilder {
    @Nullable
    public final PsiDirectory findBasePackageDirectory(@NotNull PsiDirectory dir) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            PsiFile[] psiFileArray = dir.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
            Object[] $this$any$iv = psiFileArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiFile it = (PsiFile)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PsiJavaFile)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return dir;
        }
        for (PsiDirectory sub : dir.getSubdirectories()) {
            PsiDirectory found;
            Intrinsics.checkNotNull((Object)sub);
            PsiDirectory psiDirectory = found = this.findBasePackageDirectory(sub);
            if (psiDirectory == null) continue;
            return psiDirectory;
        }
        return null;
    }

    public final boolean isController(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (psiClass.getName() == null) {
            return false;
        }
        return AnnotationResolver.INSTANCE.hasAnnotations(psiClass, (Collection<String>)SpringClassName.INSTANCE.getSPRING_CONTROLLER_ANNOTATION(), false);
    }

    public final boolean isMappingMethod(@NotNull PsiMethod method) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Iterable $this$any$iv = SpringClassName.INSTANCE.getSPRING_SINGLE_REQUEST_MAPPING_ANNOTATIONS();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!method.hasAnnotation(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final ApiNode makeRootNode(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.ROOT_DIR.getCode();
        int n3 = CodeType.MODULE.getCode();
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        String string3 = module.getName() + "[" + CodeType.MODULE.getCode() + "]";
        return new ApiNode(n, n2, n3, 0, null, string2, "", "", string3, null, null, null, null, null, 15896, null);
    }

    @NotNull
    public final ApiNode makeDirNode(@NotNull PsiDirectory subDir, @NotNull String parentPath) {
        Intrinsics.checkNotNullParameter((Object)subDir, (String)"subDir");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.DIR.getCode();
        int n3 = CodeType.DIR.getCode();
        String string = subDir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        String string3 = parentPath + "[" + CodeType.DIR.getCode() + "]";
        return new ApiNode(n, n2, n3, 0, null, string2, "", "", string3, null, null, null, null, null, 15896, null);
    }

    @NotNull
    public final ApiNode makeClassNode(@NotNull ClassHelper classHelper, @NotNull PsiClass psiClass, @NotNull String parentPath) {
        String string;
        String string2;
        String string3;
        String string4;
        Intrinsics.checkNotNullParameter((Object)classHelper, (String)"classHelper");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Pair<String, String> pair = classHelper.parseDoc((PsiElement)psiClass);
        String clsAlias = (String)pair.component1();
        String clsDesc = (String)pair.component2();
        ApiRequest request = new SpringClassResolver().resolveRequestMapping(psiClass);
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.DIR.getCode();
        int n3 = CodeType.CLASS.getCode();
        String string5 = psiClass.getName();
        if (string5 == null) {
            string5 = string4 = "";
        }
        if ((string3 = clsAlias) == null) {
            string3 = string2 = "";
        }
        if ((string = clsDesc) == null) {
            string = "";
        }
        String string6 = string;
        return new ApiNode(n, n2, n3, 0, null, string4, string2, string6, parentPath, null, null, request, null, null, 13848, null);
    }

    @Nullable
    public final ApiNode makeMethodNode(@NotNull MethodHelper methodHelper, @NotNull PsiMethod psiMethod, @NotNull String prefixPath, @NotNull ApiNode classNode, @NotNull Function2<? super MethodHelper, ? super ApiRequest, String> callback) {
        Intrinsics.checkNotNullParameter((Object)methodHelper, (String)"methodHelper");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        Intrinsics.checkNotNullParameter((Object)prefixPath, (String)"prefixPath");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Pair<String, String> pair = methodHelper.parseDoc((PsiElement)psiMethod);
        String mAlias = (String)pair.component1();
        String mDesc = (String)pair.component2();
        ApiRequest apiRequest = MethodHelper.getMethodNodeCoreInfo$default(methodHelper, classNode, false, 2, null);
        if (apiRequest == null) {
            return null;
        }
        ApiRequest request = apiRequest;
        request.setPath(PathUtils.INSTANCE.normalizeToAsyncTestPath(request.getPath()));
        request.setName(psiMethod.getName());
        String string = mAlias;
        if (string == null) {
            string = "";
        }
        request.setAlias(string);
        String string2 = mDesc;
        if (string2 == null) {
            string2 = "";
        }
        request.setDesc(string2);
        String hash = HashUtilsKt.calculateSafeHash(request);
        request.setHash(hash);
        String requestKey = (String)callback.invoke((Object)methodHelper, (Object)request);
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.INTERFACE_NODE.getCode();
        int n3 = CodeType.METHOD.getCode();
        String string3 = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String string4 = string3;
        String string5 = prefixPath + "." + psiMethod.getName() + "[" + CodeType.METHOD.getCode() + "]";
        String string6 = request.getPath();
        String string7 = request.getMethod();
        ApiNode result = new ApiNode(n, n2, n3, 0, string7, string4, mAlias, mDesc, string5, null, requestKey, null, string6, hash, 2568, null);
        return result;
    }

    @Nullable
    public final ApiNode makeMethodExcludeParam(@NotNull MethodHelper methodHelper, @NotNull PsiMethod psiMethod, @NotNull String prefixPath, @NotNull ApiNode classNode) {
        Intrinsics.checkNotNullParameter((Object)methodHelper, (String)"methodHelper");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        Intrinsics.checkNotNullParameter((Object)prefixPath, (String)"prefixPath");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        ApiRequest apiRequest = methodHelper.getMethodNodeCoreInfo(classNode, true);
        if (apiRequest == null) {
            return null;
        }
        ApiRequest request = apiRequest;
        request.setPath(PathUtils.INSTANCE.normalizeToAsyncTestPath(request.getPath()));
        String string = TreeBuilder.makeMethodExcludeParam$getRequestKey(request);
        if (string == null) {
            return null;
        }
        String requestKey = string;
        int n = NodeType.INTERFACE.getCode();
        int n2 = ChildNodeType.INTERFACE_NODE.getCode();
        int n3 = CodeType.METHOD.getCode();
        String string2 = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2;
        String string4 = prefixPath + "." + psiMethod.getName();
        String string5 = request.getPath();
        String string6 = request.getMethod();
        return new ApiNode(n, n2, n3, 0, string6, string3, null, null, string4, null, requestKey, null, string5, null, 10952, null);
    }

    private static final String makeMethodExcludeParam$getRequestKey(ApiRequest request) {
        if (request.getMethod() == null) {
            return null;
        }
        String string = request.getMethod();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2 + ":" + request.getPath();
    }
}

