/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.utils.RouteKey;
import com.sheldon.idea.plugin.api.utils.RouteRegistry;
import com.sheldon.idea.plugin.api.utils.ScanSession;
import com.sheldon.idea.plugin.api.utils.SpringConfigReader;
import com.sheldon.idea.plugin.api.utils.build.BuildRootTree;
import com.sheldon.idea.plugin.api.utils.build.TreeBuilder;
import com.sheldon.idea.plugin.api.utils.build.helper.ClassHelper;
import com.sheldon.idea.plugin.api.utils.build.helper.MethodHelper;
import com.sheldon.idea.plugin.api.utils.build.lifecycle.AfterBuildRequest;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J:\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/MethodNodeBuilder;", "Lcom/sheldon/idea/plugin/api/utils/build/TreeBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/sheldon/idea/plugin/api/utils/ScanSession;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/sheldon/idea/plugin/api/utils/ScanSession;)V", "getSession", "()Lcom/sheldon/idea/plugin/api/utils/ScanSession;", "scan", "Lcom/sheldon/idea/plugin/api/utils/RouteRegistry;", "scanModule", "module", "Lcom/intellij/openapi/module/Module;", "scanDir", "dir", "Lcom/intellij/psi/PsiDirectory;", "scanClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "scanMethod", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "classNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "collectRecursively", "", "currentDir", "routerRegistry", "prefix", "", "collectClass", "collectMethod", "", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nMethodNodeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodNodeBuilder.kt\ncom/sheldon/idea/plugin/api/utils/build/MethodNodeBuilder\n+ 2 actions.kt\ncom/intellij/openapi/application/ActionsKt\n*L\n1#1,146:1\n21#2:147\n21#2:148\n21#2:149\n21#2:150\n21#2:151\n*S KotlinDebug\n*F\n+ 1 MethodNodeBuilder.kt\ncom/sheldon/idea/plugin/api/utils/build/MethodNodeBuilder\n*L\n24#1:147\n38#1:148\n49#1:149\n57#1:150\n65#1:151\n*E\n"})
public final class MethodNodeBuilder
extends TreeBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final ScanSession session;

    public MethodNodeBuilder(@NotNull Project project, @NotNull ScanSession session) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.project = project;
        this.session = session;
    }

    @NotNull
    public final ScanSession getSession() {
        return this.session;
    }

    @NotNull
    public final RouteRegistry scan() {
        boolean $i$f$runReadAction = false;
        return (RouteRegistry)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ MethodNodeBuilder this$0;
            {
                this.this$0 = methodNodeBuilder;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void var2_2;
                boolean bl = false;
                RouteRegistry routerRegistry = new RouteRegistry();
                for (Module module : ModuleManager.Companion.getInstance(MethodNodeBuilder.access$getProject$p(this.this$0)).getModules()) {
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    PsiDirectory baseDir = new BuildRootTree(project).getBaseDir(module);
                    if (baseDir == null) continue;
                    MethodNodeBuilder.access$collectRecursively(this.this$0, baseDir, module, routerRegistry, SpringConfigReader.INSTANCE.getSpringBaseUrl(module));
                }
                return var2_2;
            }
        });
    }

    @NotNull
    public final RouteRegistry scanModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        boolean $i$f$runReadAction = false;
        return (RouteRegistry)ApplicationManager.getApplication().runReadAction(new Computable(module, this){
            final /* synthetic */ Module $module$inlined;
            final /* synthetic */ MethodNodeBuilder this$0;
            {
                this.$module$inlined = module;
                this.this$0 = methodNodeBuilder;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void var2_2;
                boolean bl = false;
                RouteRegistry routerRegistry = new RouteRegistry();
                Project project = this.$module$inlined.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PsiDirectory baseDir = new BuildRootTree(project).getBaseDir(this.$module$inlined);
                if (baseDir != null) {
                    MethodNodeBuilder.access$collectRecursively(this.this$0, baseDir, this.$module$inlined, routerRegistry, SpringConfigReader.INSTANCE.getSpringBaseUrl(this.$module$inlined));
                }
                return var2_2;
            }
        });
    }

    @NotNull
    public final RouteRegistry scanDir(@NotNull Module module, @NotNull PsiDirectory dir) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        boolean $i$f$runReadAction = false;
        return (RouteRegistry)ApplicationManager.getApplication().runReadAction(new Computable(this, dir, module){
            final /* synthetic */ MethodNodeBuilder this$0;
            final /* synthetic */ PsiDirectory $dir$inlined;
            final /* synthetic */ Module $module$inlined;
            {
                this.this$0 = methodNodeBuilder;
                this.$dir$inlined = psiDirectory;
                this.$module$inlined = module;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void var2_2;
                boolean bl = false;
                RouteRegistry routerRegistry = new RouteRegistry();
                MethodNodeBuilder.access$collectRecursively(this.this$0, this.$dir$inlined, this.$module$inlined, routerRegistry, SpringConfigReader.INSTANCE.getSpringBaseUrl(this.$module$inlined));
                return var2_2;
            }
        });
    }

    @NotNull
    public final RouteRegistry scanClass(@NotNull Module module, @NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        boolean $i$f$runReadAction = false;
        return (RouteRegistry)ApplicationManager.getApplication().runReadAction(new Computable(this, module, psiClass){
            final /* synthetic */ MethodNodeBuilder this$0;
            final /* synthetic */ Module $module$inlined;
            final /* synthetic */ PsiClass $psiClass$inlined;
            {
                this.this$0 = methodNodeBuilder;
                this.$module$inlined = module;
                this.$psiClass$inlined = psiClass;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void var2_2;
                boolean bl = false;
                RouteRegistry routerRegistry = new RouteRegistry();
                MethodNodeBuilder.access$collectClass(this.this$0, this.$module$inlined, this.$psiClass$inlined, routerRegistry, SpringConfigReader.INSTANCE.getSpringBaseUrl(this.$module$inlined));
                return var2_2;
            }
        });
    }

    @NotNull
    public final RouteRegistry scanMethod(@NotNull Module module, @NotNull PsiMethod psiMethod, @NotNull PsiClass psiClass, @NotNull ApiNode classNode) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        boolean $i$f$runReadAction = false;
        return (RouteRegistry)ApplicationManager.getApplication().runReadAction(new Computable(this, module, psiClass, psiMethod, classNode){
            final /* synthetic */ MethodNodeBuilder this$0;
            final /* synthetic */ Module $module$inlined;
            final /* synthetic */ PsiClass $psiClass$inlined;
            final /* synthetic */ PsiMethod $psiMethod$inlined;
            final /* synthetic */ ApiNode $classNode$inlined;
            {
                this.this$0 = methodNodeBuilder;
                this.$module$inlined = module;
                this.$psiClass$inlined = psiClass;
                this.$psiMethod$inlined = psiMethod;
                this.$classNode$inlined = apiNode;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void var2_2;
                boolean bl = false;
                RouteRegistry routerRegistry = new RouteRegistry();
                MethodNodeBuilder.access$collectMethod(this.this$0, this.$module$inlined, this.$psiClass$inlined, this.$psiMethod$inlined, this.$classNode$inlined, routerRegistry, SpringConfigReader.INSTANCE.getSpringBaseUrl(this.$module$inlined));
                return var2_2;
            }
        });
    }

    private final void collectRecursively(PsiDirectory currentDir, Module module, RouteRegistry routerRegistry, String prefix) {
        for (PsiFile psiFile : currentDir.getFiles()) {
            if (!(psiFile instanceof PsiJavaFile)) continue;
            for (PsiClass psiClass : ((PsiJavaFile)psiFile).getClasses()) {
                Intrinsics.checkNotNull((Object)psiClass);
                if (!this.isController(psiClass)) continue;
                this.collectClass(module, psiClass, routerRegistry, prefix);
            }
        }
        for (PsiFile psiFile : currentDir.getSubdirectories()) {
            Intrinsics.checkNotNull((Object)psiFile);
            this.collectRecursively((PsiDirectory)psiFile, module, routerRegistry, prefix);
        }
    }

    static /* synthetic */ void collectRecursively$default(MethodNodeBuilder methodNodeBuilder, PsiDirectory psiDirectory, Module module, RouteRegistry routeRegistry, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = "http://localhost:8080";
        }
        methodNodeBuilder.collectRecursively(psiDirectory, module, routeRegistry, string);
    }

    private final void collectClass(Module module, PsiClass psiClass, RouteRegistry routerRegistry, String prefix) {
        ClassHelper classHelper = new ClassHelper(module, this.project, psiClass);
        PsiMethod[] methods = classHelper.getMethods();
        ApiNode classNode = this.makeClassNode(classHelper, psiClass, "");
        for (PsiMethod psiMethod : methods) {
            if (this.collectMethod(module, psiClass, psiMethod, classNode, routerRegistry, prefix)) continue;
        }
    }

    private final boolean collectMethod(Module module, PsiClass psiClass, PsiMethod psiMethod, ApiNode classNode, RouteRegistry routerRegistry, String prefix) {
        PsiClass psiClass2 = psiMethod.getContainingClass();
        if (psiClass2 == null) {
            return false;
        }
        MethodHelper methodHelper = new MethodHelper(module, this.project, psiClass, psiMethod);
        PsiClass containingClass = psiClass2;
        if (!methodHelper.shouldIncludeMethod(psiClass, containingClass)) {
            return false;
        }
        if (this.isMappingMethod(psiMethod)) {
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ApiNode methodNode = this.makeMethodNode(methodHelper, psiMethod, string, classNode, (Function2<? super MethodHelper, ? super ApiRequest, String>)((Function2)(arg_0, arg_1) -> MethodNodeBuilder.collectMethod$lambda$5(this, prefix, arg_0, arg_1)));
            if (methodNode != null) {
                String string2;
                String string3 = methodNode.getMethod();
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = methodNode.getPath()) == null) {
                    string2 = "";
                }
                RouteKey routeKey = new RouteKey(string3, string2);
                String string4 = module.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                routerRegistry.register(routeKey, methodNode, psiClass, string4);
            }
        }
        return true;
    }

    static /* synthetic */ boolean collectMethod$default(MethodNodeBuilder methodNodeBuilder, Module module, PsiClass psiClass, PsiMethod psiMethod, ApiNode apiNode, RouteRegistry routeRegistry, String string, int n, Object object) {
        if ((n & 0x20) != 0) {
            string = "";
        }
        return methodNodeBuilder.collectMethod(module, psiClass, psiMethod, apiNode, routeRegistry, string);
    }

    private static final String collectMethod$lambda$5(MethodNodeBuilder this$0, String $prefix, MethodHelper methodHelper, ApiRequest request) {
        Intrinsics.checkNotNullParameter((Object)methodHelper, (String)"methodHelper");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new AfterBuildRequest(request).execute(methodHelper.getProject(), methodHelper.getModule(), this$0.session.getSaveMock(), $prefix);
    }

    public static final /* synthetic */ Project access$getProject$p(MethodNodeBuilder $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$collectRecursively(MethodNodeBuilder $this, PsiDirectory currentDir, Module module, RouteRegistry routerRegistry, String prefix) {
        $this.collectRecursively(currentDir, module, routerRegistry, prefix);
    }

    public static final /* synthetic */ void access$collectClass(MethodNodeBuilder $this, Module module, PsiClass psiClass, RouteRegistry routerRegistry, String prefix) {
        $this.collectClass(module, psiClass, routerRegistry, prefix);
    }

    public static final /* synthetic */ boolean access$collectMethod(MethodNodeBuilder $this, Module module, PsiClass psiClass, PsiMethod psiMethod, ApiNode classNode, RouteRegistry routerRegistry, String prefix) {
        return $this.collectMethod(module, psiClass, psiMethod, classNode, routerRegistry, prefix);
    }
}

