/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.utils.build.TreeBuilder;
import com.sheldon.idea.plugin.api.utils.build.helper.ClassHelper;
import com.sheldon.idea.plugin.api.utils.build.helper.MethodHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J:\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/BuildMethodNode;", "Lcom/sheldon/idea/plugin/api/utils/build/TreeBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/project/Project;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getProject", "()Lcom/intellij/openapi/project/Project;", "build", "", "classHelper", "Lcom/sheldon/idea/plugin/api/utils/build/helper/ClassHelper;", "psiClass", "Lcom/intellij/psi/PsiClass;", "classPath", "", "classNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "callback", "Lkotlin/Function1;", "idea-plugin"})
public final class BuildMethodNode
extends TreeBuilder {
    @NotNull
    private final Module module;
    @NotNull
    private final Project project;

    public BuildMethodNode(@NotNull Module module, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.module = module;
        this.project = project;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void build(@NotNull ClassHelper classHelper, @NotNull PsiClass psiClass, @NotNull String classPath, @NotNull ApiNode classNode, @NotNull Function1<? super ApiNode, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)classHelper, (String)"classHelper");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        for (PsiMethod psiMethod : classHelper.getMethods()) {
            ApiNode methodNode;
            PsiClass containingClass;
            MethodHelper methodHelper;
            if (psiMethod.getContainingClass() == null || !(methodHelper = new MethodHelper(this.module, this.project, psiClass, psiMethod)).shouldIncludeMethod(psiClass, containingClass) || !this.isMappingMethod(psiMethod) || (methodNode = this.makeMethodExcludeParam(methodHelper, psiMethod, classPath, classNode)) == null) continue;
            callback.invoke((Object)methodNode);
        }
    }
}

