/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiJavaFile;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.utils.build.TreeBuilder;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J:\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015J2\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015J4\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00132\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015H\u0002J<\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00132\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/BuildDirectoryTree;", "Lcom/sheldon/idea/plugin/api/utils/build/TreeBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/project/Project;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getProject", "()Lcom/intellij/openapi/project/Project;", "build", "", "rootDir", "Lcom/intellij/psi/PsiDirectory;", "rootNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "rootPrefix", "", "nextBuild", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiClass;", "buildDir", "recursiveBuildDirNode", "currentDir", "pathPrefix", "recursiveBuild", "parentNode", "idea-plugin"})
public final class BuildDirectoryTree
extends TreeBuilder {
    @NotNull
    private final Module module;
    @NotNull
    private final Project project;

    public BuildDirectoryTree(@NotNull Module module, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.module = module;
        this.project = project;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void build(@NotNull PsiDirectory rootDir, @NotNull ApiNode rootNode, @NotNull String rootPrefix, @NotNull Function2<? super PsiClass, ? super String, ApiNode> nextBuild) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)rootPrefix, (String)"rootPrefix");
        Intrinsics.checkNotNullParameter(nextBuild, (String)"nextBuild");
        this.recursiveBuild(rootDir, rootNode, rootPrefix, nextBuild);
    }

    @NotNull
    public final ApiNode buildDir(@NotNull PsiDirectory rootDir, @NotNull String rootPrefix, @NotNull Function2<? super PsiClass, ? super String, ApiNode> nextBuild) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)rootPrefix, (String)"rootPrefix");
        Intrinsics.checkNotNullParameter(nextBuild, (String)"nextBuild");
        return this.recursiveBuildDirNode(rootDir, rootPrefix, nextBuild);
    }

    private final ApiNode recursiveBuildDirNode(PsiDirectory currentDir, String pathPrefix, Function2<? super PsiClass, ? super String, ApiNode> nextBuild) {
        ApiNode currentNode = this.makeDirNode(currentDir, pathPrefix + "." + currentDir.getName());
        for (PsiDirectory psiDirectory : currentDir.getSubdirectories()) {
            String string = StringsKt.isBlank((CharSequence)pathPrefix) ? psiDirectory.getName() : pathPrefix + "." + psiDirectory.getName();
            Intrinsics.checkNotNull((Object)string);
            String subPath = string;
            Intrinsics.checkNotNull((Object)psiDirectory);
            ApiNode childDirNode = this.recursiveBuildDirNode(psiDirectory, subPath, nextBuild);
            if (!(!((Collection)childDirNode.getChildren()).isEmpty())) continue;
            currentNode.addChild(childDirNode);
        }
        for (PsiDirectory psiDirectory : currentDir.getFiles()) {
            if (!(psiDirectory instanceof PsiJavaFile)) continue;
            for (PsiClass psiClass : ((PsiJavaFile)psiDirectory).getClasses()) {
                ApiNode classNode;
                Intrinsics.checkNotNull((Object)psiClass);
                if (!this.isController(psiClass) || (classNode = (ApiNode)nextBuild.invoke((Object)psiClass, (Object)currentNode.getTree_path())) == null) continue;
                currentNode.addChild(classNode);
            }
        }
        return currentNode;
    }

    private final void recursiveBuild(PsiDirectory currentDir, ApiNode parentNode, String pathPrefix, Function2<? super PsiClass, ? super String, ApiNode> nextBuild) {
        for (PsiDirectory psiDirectory : currentDir.getSubdirectories()) {
            String currentPath = pathPrefix + "." + psiDirectory.getName();
            Intrinsics.checkNotNull((Object)psiDirectory);
            ApiNode dirNode = this.makeDirNode(psiDirectory, currentPath);
            this.recursiveBuild(psiDirectory, dirNode, dirNode.getTree_path(), nextBuild);
            if (!(!((Collection)dirNode.getChildren()).isEmpty())) continue;
            parentNode.addChild(dirNode);
        }
        for (PsiDirectory psiDirectory : currentDir.getFiles()) {
            if (!(psiDirectory instanceof PsiJavaFile)) continue;
            for (PsiClass psiClass : ((PsiJavaFile)psiDirectory).getClasses()) {
                ApiNode classNode;
                Intrinsics.checkNotNull((Object)psiClass);
                if (!this.isController(psiClass) || (classNode = (ApiNode)nextBuild.invoke((Object)psiClass, (Object)pathPrefix)) == null) continue;
                parentNode.addChild(classNode);
            }
        }
    }
}

