/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils.build;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.utils.RouteKey;
import com.sheldon.idea.plugin.api.utils.RouteRegistry;
import com.sheldon.idea.plugin.api.utils.build.BuildMethodNode;
import com.sheldon.idea.plugin.api.utils.build.TreeBuilder;
import com.sheldon.idea.plugin.api.utils.build.helper.ClassHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/sheldon/idea/plugin/api/utils/build/BuildControllerNode;", "Lcom/sheldon/idea/plugin/api/utils/build/TreeBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/project/Project;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getProject", "()Lcom/intellij/openapi/project/Project;", "build", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "psiClass", "Lcom/intellij/psi/PsiClass;", "pathPrefix", "", "routeRegistry", "Lcom/sheldon/idea/plugin/api/utils/RouteRegistry;", "buildMethod", "", "onResult", "Lkotlin/Function1;", "idea-plugin"})
public final class BuildControllerNode
extends TreeBuilder {
    @NotNull
    private final Module module;
    @NotNull
    private final Project project;

    public BuildControllerNode(@NotNull Module module, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.module = module;
        this.project = project;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final ApiNode build(@NotNull PsiClass psiClass, @NotNull String pathPrefix, @NotNull RouteRegistry routeRegistry) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)pathPrefix, (String)"pathPrefix");
        Intrinsics.checkNotNullParameter((Object)routeRegistry, (String)"routeRegistry");
        ClassHelper classHelper = new ClassHelper(this.module, this.project, psiClass);
        String classPath = pathPrefix + "." + psiClass.getName() + "[2]";
        ApiNode classNode = this.makeClassNode(classHelper, psiClass, classPath);
        new BuildMethodNode(this.module, this.project).build(classHelper, psiClass, classNode.getTree_path(), classNode, (Function1<? super ApiNode, Unit>)((Function1)arg_0 -> BuildControllerNode.build$lambda$0(routeRegistry, this, psiClass, classPath, classNode, arg_0)));
        if (classNode.getChildren().isEmpty()) {
            return null;
        }
        return classNode;
    }

    public final void buildMethod(@NotNull PsiClass psiClass, @NotNull String pathPrefix, @NotNull RouteRegistry routeRegistry, @NotNull Function1<? super ApiNode, Unit> onResult) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)pathPrefix, (String)"pathPrefix");
        Intrinsics.checkNotNullParameter((Object)routeRegistry, (String)"routeRegistry");
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        ClassHelper classHelper = new ClassHelper(this.module, this.project, psiClass);
        ApiNode classNode = this.makeClassNode(classHelper, psiClass, pathPrefix);
        new BuildMethodNode(this.module, this.project).build(classHelper, psiClass, classNode.getTree_path(), classNode, (Function1<? super ApiNode, Unit>)((Function1)arg_0 -> BuildControllerNode.buildMethod$lambda$2(routeRegistry, this, psiClass, pathPrefix, onResult, arg_0)));
    }

    private static final Unit build$lambda$0(RouteRegistry $routeRegistry, BuildControllerNode this$0, PsiClass $psiClass, String $classPath, ApiNode $classNode, ApiNode methodNode) {
        ApiNode newMethodNode;
        String string;
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        String string2 = this$0.module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = methodNode.getMethod();
        if (string3 == null) {
            string3 = "";
        }
        if ((string = methodNode.getPath()) == null) {
            string = "";
        }
        if ((newMethodNode = $routeRegistry.getApiNode(string2, new RouteKey(string3, string), $psiClass)) != null) {
            newMethodNode.setTree_path($classPath + "." + newMethodNode.getName() + "[3]");
            $classNode.addChild(newMethodNode);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildMethod$lambda$2(RouteRegistry $routeRegistry, BuildControllerNode this$0, PsiClass $psiClass, String $pathPrefix, Function1 $onResult, ApiNode methodNode) {
        block2: {
            ApiNode newMethodNode;
            String string;
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            String string2 = this$0.module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = methodNode.getMethod();
            if (string3 == null) {
                string3 = "";
            }
            if ((string = methodNode.getPath()) == null) {
                string = "";
            }
            ApiNode apiNode = newMethodNode = $routeRegistry.getApiNode(string2, new RouteKey(string3, string), $psiClass);
            if (apiNode == null) break block2;
            ApiNode it = apiNode;
            boolean bl = false;
            it.setTree_path($pathPrefix + "." + it.getName() + "[3]");
            $onResult.invoke((Object)it);
        }
        return Unit.INSTANCE;
    }
}

