/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.sheldon.idea.plugin.api.utils.build.resolver.ResolverHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/sheldon/idea/plugin/api/utils/TypeUtils;", "", "<init>", "()V", "mapToAsyncType", "", "type", "Lcom/intellij/psi/PsiType;", "isArrayOrCollection", "", "isMapType", "isGeneralObject", "getRealTypeForMethod", "method", "Lcom/intellij/psi/PsiMethod;", "currentClass", "Lcom/intellij/psi/PsiClass;", "idea-plugin"})
public final class TypeUtils {
    @NotNull
    public static final TypeUtils INSTANCE = new TypeUtils();

    private TypeUtils() {
    }

    @NotNull
    public final String mapToAsyncType(@NotNull PsiType type2) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                String string = type2.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
                String canonicalText = string;
                if (ResolverHelper.Companion.isMultipartFile(type2)) {
                    return "files";
                }
                if (this.isArrayOrCollection(type2)) {
                    return "array";
                }
                if (PsiType.INT.isAssignableFrom(type2) || PsiType.LONG.isAssignableFrom(type2) || PsiType.SHORT.isAssignableFrom(type2) || PsiType.BYTE.isAssignableFrom(type2) || Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.Integer") || Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.Long")) {
                    return "integer";
                }
                if (PsiType.DOUBLE.isAssignableFrom(type2) || PsiType.FLOAT.isAssignableFrom(type2) || Intrinsics.areEqual((Object)canonicalText, (Object)"java.math.BigDecimal")) {
                    return "number";
                }
                if (PsiType.BOOLEAN.isAssignableFrom(type2) || Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.Boolean")) {
                    return "boolean";
                }
                if (PsiType.VOID.isAssignableFrom(type2)) {
                    return "null";
                }
                if (Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.String") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Date") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.time.temporal.Temporal")) break block10;
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
                boolean bl = psiClass != null ? psiClass.isEnum() : false;
                if (!bl) break block11;
            }
            return "string";
        }
        if (this.isMapType(type2)) {
            return "object";
        }
        return "ds";
    }

    public final boolean isArrayOrCollection(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2 instanceof PsiArrayType) {
            return true;
        }
        String string = type2.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        if (StringsKt.startsWith$default((String)string, (String)"java.util.Collection", (boolean)false, (int)2, null)) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection");
    }

    public final boolean isMapType(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        String string = type2.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        if (StringsKt.startsWith$default((String)string, (String)"java.util.Map", (boolean)false, (int)2, null)) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
    }

    public final boolean isGeneralObject(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return Intrinsics.areEqual((Object)type2.getCanonicalText(), (Object)"java.lang.Object");
    }

    @NotNull
    public final PsiType getRealTypeForMethod(@NotNull PsiMethod method, @NotNull PsiType type2, @NotNull PsiClass currentClass) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)currentClass, (String)"currentClass");
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && !Intrinsics.areEqual((Object)containingClass, (Object)currentClass)) {
            PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)currentClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSuperClassSubstitutor(...)");
            PsiSubstitutor substitutor = psiSubstitutor;
            psiType = substitutor.substitute(type2);
        } else {
            psiType = type2;
        }
        PsiType realType = psiType;
        Intrinsics.checkNotNull((Object)realType);
        return realType;
    }
}

