/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/sheldon/idea/plugin/api/utils/SpringConfigReader;", "", "<init>", "()V", "DEFAULT_PORT", "", "DEFAULT_HOST", "getSpringBaseUrl", "module", "Lcom/intellij/openapi/module/Module;", "readSpringConfig", "", "parseProperties", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "parseYaml", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nSpringConfigReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringConfigReader.kt\ncom/sheldon/idea/plugin/api/utils/SpringConfigReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class SpringConfigReader {
    @NotNull
    public static final SpringConfigReader INSTANCE = new SpringConfigReader();
    @NotNull
    private static final String DEFAULT_PORT = "8080";
    @NotNull
    private static final String DEFAULT_HOST = "http://localhost";

    private SpringConfigReader() {
    }

    @NotNull
    public final String getSpringBaseUrl(@NotNull Module module) {
        Object contextPath;
        String string;
        String port;
        Map<String, String> config;
        block7: {
            String string2;
            block6: {
                String string3;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                config = this.readSpringConfig(module);
                string2 = config.get("port");
                if (string2 == null) break block6;
                String it = string3 = string2;
                boolean bl = false;
                string2 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                if (string2 != null) break block7;
            }
            string2 = port = DEFAULT_PORT;
        }
        if ((string = config.get("context-path")) == null) {
            string = "";
        }
        if (((CharSequence)(contextPath = string)).length() > 0 && !StringsKt.startsWith$default((String)contextPath, (String)"/", (boolean)false, (int)2, null)) {
            contextPath = "/" + (String)contextPath;
        }
        if (Intrinsics.areEqual((Object)contextPath, (Object)"/")) {
            contextPath = "";
        }
        return "http://localhost:" + port + (String)contextPath;
    }

    private final Map<String, String> readSpringConfig(Module module) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleRuntimeScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        Map finalConfig = new LinkedHashMap();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bootstrap.properties", (Object)false), TuplesKt.to((Object)"bootstrap.yml", (Object)true), TuplesKt.to((Object)"application.properties", (Object)false), TuplesKt.to((Object)"application.yml", (Object)true)};
        List fileNames = CollectionsKt.listOf((Object[])pairArray);
        for (Pair pair : fileNames) {
            Map<String, String> map;
            Collection files;
            String fileName = (String)pair.component1();
            boolean isYaml = (Boolean)pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)scope), (String)"getVirtualFilesByName(...)");
            if (!(!files.isEmpty())) continue;
            VirtualFile file = (VirtualFile)CollectionsKt.first((Iterable)files);
            if (isYaml) {
                Intrinsics.checkNotNull((Object)file);
                map = this.parseYaml(project2, file);
            } else {
                Intrinsics.checkNotNull((Object)file);
                map = this.parseProperties(project2, file);
            }
            Map<String, String> configMap = map;
            finalConfig.putAll(configMap);
        }
        return finalConfig;
    }

    private final Map<String, String> parseProperties(Project project, VirtualFile file) {
        Object contextPath;
        Object object;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        PropertiesFile propertiesFile = psiFile instanceof PropertiesFile ? (PropertiesFile)psiFile : null;
        if (propertiesFile == null) {
            return MapsKt.emptyMap();
        }
        PropertiesFile psiFile2 = propertiesFile;
        Map result = new LinkedHashMap();
        Object object2 = psiFile2.findPropertyByKey("server.port");
        if (object2 != null && (object2 = object2.getValue()) != null) {
            Object it = object2;
            boolean bl = false;
            result.put("port", it);
        }
        if ((object = psiFile2.findPropertyByKey("server.servlet.context-path")) == null || (object = object.getValue()) == null) {
            IProperty iProperty = psiFile2.findPropertyByKey("server.context-path");
            object = iProperty != null ? iProperty.getValue() : null;
        }
        if ((contextPath = object) != null) {
            result.put("context-path", contextPath);
        }
        return result;
    }

    private final Map<String, String> parseYaml(Project project, VirtualFile file) {
        String contextPath;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
        if (yAMLFile == null) {
            return MapsKt.emptyMap();
        }
        YAMLFile psiFile2 = yAMLFile;
        Map result = new LinkedHashMap();
        List documents = psiFile2.getDocuments();
        if (documents.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Object[] objectArray = ((YAMLDocument)documents.get(0)).getTopLevelValue();
        YAMLMapping yAMLMapping = objectArray instanceof YAMLMapping ? (YAMLMapping)objectArray : null;
        if (yAMLMapping == null) {
            return MapsKt.emptyMap();
        }
        YAMLMapping topValue = yAMLMapping;
        objectArray = new String[]{"server", "port"};
        String string = SpringConfigReader.parseYaml$findValue(CollectionsKt.listOf((Object[])objectArray), topValue);
        if (string != null) {
            String it = string;
            boolean bl = false;
            result.put("port", it);
        }
        Object[] objectArray2 = new String[]{"server", "servlet", "context-path"};
        String string2 = SpringConfigReader.parseYaml$findValue(CollectionsKt.listOf((Object[])objectArray2), topValue);
        if (string2 == null) {
            objectArray2 = new String[]{"server", "context-path"};
            string2 = SpringConfigReader.parseYaml$findValue(CollectionsKt.listOf((Object[])objectArray2), topValue);
        }
        if ((contextPath = string2) != null) {
            result.put("context-path", contextPath);
        }
        return result;
    }

    private static final String parseYaml$findValue(List<String> keys, YAMLMapping mapping) {
        String key = (String)CollectionsKt.first(keys);
        YAMLKeyValue yAMLKeyValue = mapping.getKeyValueByKey(key);
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLKeyValue keyValue = yAMLKeyValue;
        if (keys.size() == 1) {
            YAMLValue yAMLValue = keyValue.getValue();
            YAMLScalar yAMLScalar = yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null;
            return yAMLScalar != null ? yAMLScalar.getTextValue() : null;
        }
        YAMLValue yAMLValue = keyValue.getValue();
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return null;
        }
        YAMLMapping nextMapping = yAMLMapping;
        return SpringConfigReader.parseYaml$findValue(CollectionsKt.drop((Iterable)keys, (int)1), nextMapping);
    }
}

