/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.intellij.psi.PsiClass;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.utils.RouteKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J \u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0006R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/sheldon/idea/plugin/api/utils/RouteRegistry;", "", "<init>", "()V", "moduleRegistryContainer", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/sheldon/idea/plugin/api/utils/RouteKey;", "Lcom/sheldon/idea/plugin/api/utils/RouteRegistry$RegistryEntry;", "getModuleRegistryContainer", "()Ljava/util/concurrent/ConcurrentHashMap;", "register", "", "key", "newNode", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "newClass", "Lcom/intellij/psi/PsiClass;", "module", "getApiNode", "queryClass", "clearModule", "RegistryEntry", "idea-plugin"})
public final class RouteRegistry {
    @NotNull
    private final ConcurrentHashMap<String, Map<RouteKey, RegistryEntry>> moduleRegistryContainer = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<String, Map<RouteKey, RegistryEntry>> getModuleRegistryContainer() {
        return this.moduleRegistryContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull RouteKey key, @NotNull ApiNode newNode, @NotNull PsiClass newClass, @NotNull String module) {
        Map routeMap;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
        Intrinsics.checkNotNullParameter((Object)newClass, (String)"newClass");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map map = this.moduleRegistryContainer.computeIfAbsent(module, arg_0 -> RouteRegistry.register$lambda$1(RouteRegistry::register$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
        Map map2 = routeMap = map;
        synchronized (map2) {
            boolean bl = false;
            RegistryEntry existingEntry = (RegistryEntry)routeMap.get(key);
            if (existingEntry == null) {
                routeMap.put(key, new RegistryEntry(newNode, newClass));
                return;
            }
            PsiClass oldClass = existingEntry.getPsiClass();
            if (newClass.isInheritor(oldClass, true)) {
                routeMap.put(key, new RegistryEntry(newNode, newClass));
                return;
            }
            if (oldClass.isInheritor(newClass, true)) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final ApiNode getApiNode(@NotNull String module, @NotNull RouteKey key, @NotNull PsiClass queryClass) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)queryClass, (String)"queryClass");
        Map<RouteKey, RegistryEntry> map = this.moduleRegistryContainer.get(module);
        if (map == null) {
            return null;
        }
        Map<RouteKey, RegistryEntry> routeMap = map;
        RegistryEntry registryEntry = routeMap.get(key);
        if (registryEntry == null) {
            return null;
        }
        RegistryEntry entry = registryEntry;
        if (Intrinsics.areEqual((Object)entry.getPsiClass(), (Object)queryClass)) {
            return entry.getNode();
        }
        return null;
    }

    public final void clearModule(@NotNull String module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.moduleRegistryContainer.remove(module);
    }

    private static final Map register$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final Map register$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/sheldon/idea/plugin/api/utils/RouteRegistry$RegistryEntry;", "", "node", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "psiClass", "Lcom/intellij/psi/PsiClass;", "<init>", "(Lcom/sheldon/idea/plugin/api/model/ApiNode;Lcom/intellij/psi/PsiClass;)V", "getNode", "()Lcom/sheldon/idea/plugin/api/model/ApiNode;", "getPsiClass", "()Lcom/intellij/psi/PsiClass;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea-plugin"})
    public static final class RegistryEntry {
        @NotNull
        private final ApiNode node;
        @NotNull
        private final PsiClass psiClass;

        public RegistryEntry(@NotNull ApiNode node, @NotNull PsiClass psiClass) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
            this.node = node;
            this.psiClass = psiClass;
        }

        @NotNull
        public final ApiNode getNode() {
            return this.node;
        }

        @NotNull
        public final PsiClass getPsiClass() {
            return this.psiClass;
        }

        @NotNull
        public final ApiNode component1() {
            return this.node;
        }

        @NotNull
        public final PsiClass component2() {
            return this.psiClass;
        }

        @NotNull
        public final RegistryEntry copy(@NotNull ApiNode node, @NotNull PsiClass psiClass) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
            return new RegistryEntry(node, psiClass);
        }

        public static /* synthetic */ RegistryEntry copy$default(RegistryEntry registryEntry, ApiNode apiNode, PsiClass psiClass, int n, Object object) {
            if ((n & 1) != 0) {
                apiNode = registryEntry.node;
            }
            if ((n & 2) != 0) {
                psiClass = registryEntry.psiClass;
            }
            return registryEntry.copy(apiNode, psiClass);
        }

        @NotNull
        public String toString() {
            return "RegistryEntry(node=" + this.node + ", psiClass=" + this.psiClass + ")";
        }

        public int hashCode() {
            int result = this.node.hashCode();
            result = result * 31 + this.psiClass.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegistryEntry)) {
                return false;
            }
            RegistryEntry registryEntry = (RegistryEntry)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)registryEntry.node)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.psiClass, (Object)registryEntry.psiClass);
        }
    }
}

