/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.sheldon.idea.plugin.api.method.AsyncTestVariableNode;
import com.sheldon.idea.plugin.api.model.ApiMockRequest;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.utils.ProjectCacheService;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J&\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002J0\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u00142\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/sheldon/idea/plugin/api/utils/MockGenerator;", "", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "generate", "Lcom/sheldon/idea/plugin/api/model/ApiMockRequest;", "request", "Lcom/sheldon/idea/plugin/api/model/ApiRequest;", "prefix", "", "dsResolver", "Lkotlin/Function1;", "Lcom/sheldon/idea/plugin/api/method/AsyncTestVariableNode;", "buildHeaders", "headers", "", "buildQueryJson", "query", "buildBody", "parseNodeValue", "originalNode", "depth", "", "toUrlEncodedQuery", "jsonQuery", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nMockGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockGenerator.kt\ncom/sheldon/idea/plugin/api/utils/MockGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1863#2,2:143\n1863#2,2:145\n1863#2,2:147\n1863#2,2:149\n1863#2,2:151\n*S KotlinDebug\n*F\n+ 1 MockGenerator.kt\ncom/sheldon/idea/plugin/api/utils/MockGenerator\n*L\n33#1:143,2\n43#1:145,2\n61#1:147,2\n102#1:149,2\n113#1:151,2\n*E\n"})
public final class MockGenerator {
    @NotNull
    private final Module module;
    private final Gson gson;

    public MockGenerator(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final ApiMockRequest generate(@NotNull ApiRequest request, @NotNull String prefix, @NotNull Function1<? super String, AsyncTestVariableNode> dsResolver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(dsResolver, (String)"dsResolver");
        return new ApiMockRequest(request.getPath(), request.getMethod(), this.buildHeaders(request.getHeaders()), this.buildQueryJson(request.getQuery()), request.getBodyType(), this.buildBody(request, dsResolver), prefix);
    }

    public static /* synthetic */ ApiMockRequest generate$default(MockGenerator mockGenerator, ApiRequest apiRequest, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = arg_0 -> MockGenerator.generate$lambda$0(mockGenerator, arg_0);
        }
        return mockGenerator.generate(apiRequest, string, (Function1<? super String, AsyncTestVariableNode>)function1);
    }

    private final String buildHeaders(List<AsyncTestVariableNode> headers) {
        String string;
        Map headerMap = new LinkedHashMap();
        Iterable $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncTestVariableNode node = (AsyncTestVariableNode)element$iv;
            boolean bl = false;
            if (!(((CharSequence)node.getName()).length() > 0)) continue;
            headerMap.put(node.getName(), node.getDefaultValue());
        }
        if (headerMap.isEmpty()) {
            string = "";
        } else {
            String string2 = this.gson.toJson((Object)headerMap);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
        }
        return string;
    }

    private final String buildQueryJson(List<AsyncTestVariableNode> query) {
        String string;
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncTestVariableNode node = (AsyncTestVariableNode)element$iv;
            boolean bl = false;
            if (!(((CharSequence)node.getName()).length() > 0)) continue;
            map.put(node.getName(), node.getDefaultValue());
        }
        if (map.isEmpty()) {
            string = "";
        } else {
            String string2 = this.gson.toJson((Object)map);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String buildBody(ApiRequest request, Function1<? super String, AsyncTestVariableNode> dsResolver) {
        String string = request.getBodyType();
        if (string == null) return "";
        int n = -1;
        switch (string.hashCode()) {
            case 1763073811: {
                if (string.equals("form-data")) {
                    n = 1;
                }
                break;
            }
            case 3271912: {
                if (string.equals("json")) {
                    n = 2;
                }
                break;
            }
            case 3387192: {
                if (string.equals("none")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                AsyncTestVariableNode asyncTestVariableNode = (AsyncTestVariableNode)CollectionsKt.firstOrNull((List)request.getJson());
                if (asyncTestVariableNode == null) {
                    return "";
                }
                AsyncTestVariableNode rootNode = asyncTestVariableNode;
                Object jsonObject = this.parseNodeValue(rootNode, dsResolver, 0);
                String string2 = this.gson.toJson(jsonObject);
                Intrinsics.checkNotNull((Object)string2);
                String string3 = string2;
                return string3;
            }
            case 1: {
                Map formDataMap = new LinkedHashMap();
                Iterable $this$forEach$iv = request.getFormData().getData();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AsyncTestVariableNode node = (AsyncTestVariableNode)element$iv;
                    boolean bl = false;
                    if (!(((CharSequence)node.getName()).length() > 0)) continue;
                    if (Intrinsics.areEqual((Object)node.getType(), (Object)"files")) {
                        formDataMap.put(node.getName(), "[FILE]" + node.getDefaultValue());
                        continue;
                    }
                    formDataMap.put(node.getName(), node.getDefaultValue());
                }
                String string4 = this.gson.toJson((Object)formDataMap);
                Intrinsics.checkNotNull((Object)string4);
                String string3 = string4;
                return string3;
            }
            case 3: {
                return "";
            }
            default: {
                return "";
            }
        }
    }

    private final Object parseNodeValue(AsyncTestVariableNode originalNode, Function1<? super String, AsyncTestVariableNode> dsResolver, int depth) {
        CharSequence charSequence;
        if (depth > 10) {
            return null;
        }
        AsyncTestVariableNode workingNode = originalNode;
        if ((Intrinsics.areEqual((Object)workingNode.getType(), (Object)"ds") || Intrinsics.areEqual((Object)workingNode.getType(), (Object)"object") || Intrinsics.areEqual((Object)workingNode.getType(), (Object)"array")) && workingNode.getChildren().isEmpty() && !((charSequence = (CharSequence)workingNode.getDsTarget()) == null || charSequence.length() == 0)) {
            String string = workingNode.getDsTarget();
            Intrinsics.checkNotNull((Object)string);
            AsyncTestVariableNode resolvedNode = (AsyncTestVariableNode)dsResolver.invoke((Object)string);
            if (resolvedNode != null) {
                workingNode = resolvedNode;
            }
        }
        return switch (workingNode.getType()) {
            case "string" -> workingNode.getDefaultValue();
            case "integer" -> {
                Integer v2 = StringsKt.toIntOrNull((String)workingNode.getDefaultValue());
                yield v2 != null ? v2 : 0;
            }
            case "number" -> {
                Double v3 = StringsKt.toDoubleOrNull((String)workingNode.getDefaultValue());
                yield v3 != null ? v3 : 0.0;
            }
            case "boolean" -> Boolean.parseBoolean(workingNode.getDefaultValue());
            case "null" -> null;
            case "ds", "object" -> {
                Map map = new LinkedHashMap();
                Iterable $this$forEach$iv = workingNode.getChildren();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AsyncTestVariableNode child = (AsyncTestVariableNode)element$iv;
                    boolean $i$a$-forEach-MockGenerator$parseNodeValue$1 = false;
                    if (!(((CharSequence)child.getName()).length() > 0)) continue;
                    map.put(child.getName(), this.parseNodeValue(child, dsResolver, depth + 1));
                }
                yield map;
            }
            case "array" -> {
                List list = new ArrayList();
                if (!((Collection)workingNode.getChildren()).isEmpty()) {
                    Iterable $this$forEach$iv = workingNode.getChildren();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AsyncTestVariableNode child = (AsyncTestVariableNode)element$iv;
                        boolean $i$a$-forEach-MockGenerator$parseNodeValue$2 = false;
                        list.add(this.parseNodeValue(child, dsResolver, depth + 1));
                    }
                } else {
                    CharSequence $this$forEach$iv = workingNode.getDsTarget();
                    if (!($this$forEach$iv == null || $this$forEach$iv.length() == 0)) {
                        String v4 = workingNode.getDsTarget();
                        Intrinsics.checkNotNull((Object)v4);
                        AsyncTestVariableNode itemTemplate = (AsyncTestVariableNode)dsResolver.invoke((Object)v4);
                        if (itemTemplate != null) {
                            list.add(this.parseNodeValue(itemTemplate, dsResolver, depth + 1));
                        }
                    }
                }
                yield list;
            }
            default -> workingNode.getDefaultValue();
        };
    }

    @NotNull
    public final String toUrlEncodedQuery(@Nullable String jsonQuery) {
        CharSequence charSequence = jsonQuery;
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        try {
            Map map = (Map)this.gson.fromJson(jsonQuery, Map.class);
            if (map == null) {
                return "";
            }
            Map map2 = map;
            return CollectionsKt.joinToString$default((Iterable)map2.entrySet(), (CharSequence)"&", null, null, (int)0, null, MockGenerator::toUrlEncodedQuery$lambda$6, (int)30, null);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static final AsyncTestVariableNode generate$lambda$0(MockGenerator this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Project project = this$0.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ProjectCacheService cacheService = ProjectCacheService.Companion.getInstance(project);
        String string = this$0.module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object object = cacheService.getDataStructure(string, key);
        return object != null && (object = object.getData()) != null ? (AsyncTestVariableNode)CollectionsKt.firstOrNull((List)object) : null;
    }

    private static final CharSequence toUrlEncodedQuery$lambda$6(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Object k = entry.getKey();
        Object v = entry.getValue();
        String encodedName = URLEncoder.encode(String.valueOf(k), StandardCharsets.UTF_8.toString());
        String encodedValue = URLEncoder.encode(String.valueOf(v), StandardCharsets.UTF_8.toString());
        return encodedName + "=" + encodedValue;
    }
}

