/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.sheldon.idea.plugin.api.utils.HttpMethod;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0001J\u0006\u0010\u0013\u001a\u00020\u0005J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/sheldon/idea/plugin/api/utils/HttpExecutor;", "", "<init>", "()V", "url", "", "method", "queryParams", "", "headers", "body", "setUrl", "", "setMethod", "setParam", "key", "value", "setHeader", "setBody", "send", "createRequestBody", "Lokhttp3/RequestBody;", "isMultipart", "", "map", "", "buildFormBody", "buildMultipartBody", "Companion", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nNetworkClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkClient.kt\ncom/sheldon/idea/plugin/api/utils/HttpExecutor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n216#2,2:142\n216#2,2:144\n216#2,2:149\n216#2,2:151\n1755#3,3:146\n*S KotlinDebug\n*F\n+ 1 NetworkClient.kt\ncom/sheldon/idea/plugin/api/utils/HttpExecutor\n*L\n53#1:142,2\n59#1:144,2\n107#1:149,2\n115#1:151,2\n102#1:146,3\n*E\n"})
public final class HttpExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String url = "";
    @NotNull
    private String method = "GET";
    @NotNull
    private final Map<String, String> queryParams = new LinkedHashMap();
    @NotNull
    private final Map<String, String> headers = new LinkedHashMap();
    @Nullable
    private Object body;
    @NotNull
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();

    public final void setUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    public final void setMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        this.method = string;
    }

    public final void setParam(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.queryParams.put(key, value);
    }

    public final void setHeader(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.headers.put(key, value);
    }

    public final void setBody(@NotNull Object body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.body = body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String send() {
        try {
            Object object;
            Object object2;
            Object object3;
            HttpUrl.Builder builder;
            HttpUrl httpUrl = HttpUrl.Companion.parse(this.url);
            if (httpUrl == null || (builder = httpUrl.newBuilder()) == null) {
                throw new IllegalArgumentException("\u65e0\u6548\u7684 URL: " + this.url);
            }
            HttpUrl.Builder httpUrlBuilder = builder;
            Map<String, String> $this$forEach$iv = this.queryParams;
            boolean $i$f$forEach = false;
            for (Map.Entry<String, String> element$iv : $this$forEach$iv.entrySet()) {
                object3 = element$iv;
                boolean bl = false;
                String k = object3.getKey();
                String v = object3.getValue();
                httpUrlBuilder.addQueryParameter(k, v);
            }
            HttpUrl finalUrl = httpUrlBuilder.build();
            RequestBody requestBody = this.createRequestBody();
            Request.Builder $this$send_u24lambda_u242 = object2 = new Request.Builder().url(finalUrl);
            boolean bl = false;
            Map<String, String> $this$forEach$iv2 = this.headers;
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String k = entry.getKey();
                String v = entry.getValue();
                $this$send_u24lambda_u242.addHeader(k, v);
            }
            Request request = object2.method(this.method, requestBody).build();
            object2 = (Closeable)client.newCall(request).execute();
            object3 = null;
            try {
                Response response = (Response)object2;
                boolean bl3 = false;
                Object object4 = response.body();
                if (object4 == null || (object4 = object4.string()) == null) {
                    object4 = "";
                }
                object = object4;
            }
            catch (Throwable throwable) {
                try {
                    object3 = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)object2, object3);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private final RequestBody createRequestBody() {
        if (!HttpMethod.INSTANCE.requiresRequestBody(this.method) && this.body == null) {
            return null;
        }
        if (HttpMethod.INSTANCE.requiresRequestBody(this.method) && this.body == null) {
            return RequestBody.Companion.create(new byte[0], null, 0, 0);
        }
        Object currentBody = this.body;
        return currentBody instanceof String ? RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (String)((String)currentBody), null, (int)1, null) : (currentBody instanceof Map ? (this.isMultipart((Map)currentBody) ? this.buildMultipartBody((Map)currentBody) : this.buildFormBody((Map)currentBody)) : null);
    }

    private final boolean isMultipart(Map<?, ?> map) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = map.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(it instanceof File)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final RequestBody buildFormBody(Map<?, ?> map) {
        FormBody.Builder builder = new FormBody.Builder(null, 1, null);
        Map<?, ?> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> element$iv;
            Map.Entry<?, ?> entry = element$iv = iterator.next();
            boolean bl = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            builder.add(String.valueOf(k), String.valueOf(v));
        }
        return (RequestBody)builder.build();
    }

    private final RequestBody buildMultipartBody(Map<?, ?> map) {
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        Map<?, ?> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            MultipartBody.Builder builder2;
            Map.Entry<?, ?> element$iv;
            Map.Entry<?, ?> entry = element$iv = iterator.next();
            boolean bl = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            String keyStr = String.valueOf(k);
            if (v instanceof File) {
                String string;
                String string2;
                try {
                    string2 = Files.probeContentType(((File)v).toPath());
                }
                catch (Exception e) {
                    string2 = null;
                }
                if ((string = string2) == null) {
                    string = "application/octet-stream";
                }
                String mimeType = string;
                RequestBody fileBody = RequestBody.Companion.create((File)v, MediaType.Companion.parse(mimeType));
                builder2 = builder.addFormDataPart(keyStr, ((File)v).getName(), fileBody);
                continue;
            }
            builder2 = builder.addFormDataPart(keyStr, String.valueOf(v));
        }
        return (RequestBody)builder.build();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/sheldon/idea/plugin/api/utils/HttpExecutor$Companion;", "", "<init>", "()V", "client", "Lokhttp3/OkHttpClient;", "idea-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

