/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u0002H\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006J \u0010\u000f\u001a\u0004\u0018\u0001H\n\"\u0006\b\u0000\u0010\n\u0018\u00012\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0006J\b\u0010\u0017\u001a\u00020\tH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/sheldon/idea/plugin/api/utils/GlobalObjectStorageService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "storage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "save", "", "T", "key", "node", "(Ljava/lang/String;Ljava/lang/Object;)V", "getRaw", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "contains", "", "clear", "acquireLock", "lockKey", "releaseLock", "dispose", "idea-plugin"})
public final class GlobalObjectStorageService
implements Disposable {
    @NotNull
    private final ConcurrentHashMap<String, Object> storage = new ConcurrentHashMap();

    public final <T> void save(@NotNull String key, @NotNull T node) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        ((Map)this.storage).put(key, node);
    }

    @Nullable
    public final Object getRaw(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.storage.get(key);
    }

    public final /* synthetic */ <T> T get(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean $i$f$get = false;
        Object object = this.getRaw(key);
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.storage.containsKey(key);
    }

    public final void clear() {
        this.storage.clear();
    }

    public final boolean acquireLock(@NotNull String lockKey) {
        Intrinsics.checkNotNullParameter((Object)lockKey, (String)"lockKey");
        return this.storage.putIfAbsent(lockKey, true) == null;
    }

    public final void releaseLock(@NotNull String lockKey) {
        Intrinsics.checkNotNullParameter((Object)lockKey, (String)"lockKey");
        this.storage.remove(lockKey);
    }

    public void dispose() {
        this.storage.clear();
    }
}

