/*
 * Decompiled with CFR 0.152.
 */
package com.sheldon.idea.plugin.api.front.dashboard.utils;

import com.intellij.openapi.project.Project;
import com.sheldon.idea.plugin.api.method.AsyncTestVariableNode;
import com.sheldon.idea.plugin.api.model.ApiNode;
import com.sheldon.idea.plugin.api.model.ApiRequest;
import com.sheldon.idea.plugin.api.model.DataStructure;
import com.sheldon.idea.plugin.api.utils.ProjectCacheService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/sheldon/idea/plugin/api/front/dashboard/utils/DependencyCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "cacheService", "Lcom/sheldon/idea/plugin/api/utils/ProjectCacheService;", "kotlin.jvm.PlatformType", "Lcom/sheldon/idea/plugin/api/utils/ProjectCacheService;", "collectedDependencies", "", "expandedDefinitions", "", "collect", "", "node", "Lcom/sheldon/idea/plugin/api/model/ApiNode;", "traverseApiNode", "", "processInterfaceNode", "processVariableNode", "varNode", "Lcom/sheldon/idea/plugin/api/method/AsyncTestVariableNode;", "expandDataStructureDefinition", "target", "dataStructure", "Lcom/sheldon/idea/plugin/api/model/DataStructure;", "idea-plugin"})
@SourceDebugExtension(value={"SMAP\nDependencyCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyCollector.kt\ncom/sheldon/idea/plugin/api/front/dashboard/utils/DependencyCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1863#2,2:123\n1863#2,2:125\n1863#2,2:127\n1863#2,2:129\n*S KotlinDebug\n*F\n+ 1 DependencyCollector.kt\ncom/sheldon/idea/plugin/api/front/dashboard/utils/DependencyCollector\n*L\n44#1:123,2\n89#1:125,2\n101#1:127,2\n118#1:129,2\n*E\n"})
public final class DependencyCollector {
    @NotNull
    private final Project project;
    @NotNull
    private final String moduleName;
    private final ProjectCacheService cacheService;
    @NotNull
    private final Map<String, String> collectedDependencies;
    @NotNull
    private final Set<String> expandedDefinitions;

    public DependencyCollector(@NotNull Project project, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this.project = project;
        this.moduleName = moduleName;
        this.cacheService = (ProjectCacheService)this.project.getService(ProjectCacheService.class);
        this.collectedDependencies = new LinkedHashMap();
        this.expandedDefinitions = new LinkedHashSet();
    }

    @NotNull
    public final Map<String, String> collect(@NotNull ApiNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.collectedDependencies.clear();
        this.expandedDefinitions.clear();
        this.traverseApiNode(node);
        return this.collectedDependencies;
    }

    private final void traverseApiNode(ApiNode node) {
        if (node.getCode_type() == 3) {
            this.processInterfaceNode(node);
        }
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ApiNode child = (ApiNode)element$iv;
            boolean bl = false;
            this.traverseApiNode(child);
        }
    }

    private final void processInterfaceNode(ApiNode node) {
        String string = node.getRequest();
        if (string == null) {
            return;
        }
        String requestPath = string;
        ApiRequest apiRequest = this.cacheService.getRequest(this.moduleName, requestPath);
        if (apiRequest == null) {
            return;
        }
        ApiRequest apiRequest2 = apiRequest;
        if (Intrinsics.areEqual((Object)apiRequest2.getBodyType(), (Object)"json")) {
            AsyncTestVariableNode asyncTestVariableNode = (AsyncTestVariableNode)CollectionsKt.firstOrNull((List)apiRequest2.getJson());
            if (asyncTestVariableNode == null) {
                return;
            }
            AsyncTestVariableNode rootVarNode = asyncTestVariableNode;
            this.processVariableNode(rootVarNode);
        }
    }

    private final void processVariableNode(AsyncTestVariableNode varNode) {
        block5: {
            block4: {
                DataStructure dataStructure;
                if (!Intrinsics.areEqual((Object)varNode.getType(), (Object)"ds")) break block4;
                String target = varNode.getDsTarget();
                CharSequence charSequence = target;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (dataStructure = this.cacheService.getDataStructure(this.moduleName, target)) == null) break block5;
                this.collectedDependencies.put(target, dataStructure.getHash());
                if (!((Collection)varNode.getChildren()).isEmpty()) {
                    Iterable $this$forEach$iv = varNode.getChildren();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AsyncTestVariableNode child = (AsyncTestVariableNode)element$iv;
                        boolean bl = false;
                        this.processVariableNode(child);
                    }
                } else {
                    this.expandDataStructureDefinition(target, dataStructure);
                }
                break block5;
            }
            Iterable $this$forEach$iv = varNode.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AsyncTestVariableNode child = (AsyncTestVariableNode)element$iv;
                boolean bl = false;
                this.processVariableNode(child);
            }
        }
    }

    private final void expandDataStructureDefinition(String target, DataStructure dataStructure) {
        if (this.expandedDefinitions.contains(target)) {
            return;
        }
        this.expandedDefinitions.add(target);
        Iterable $this$forEach$iv = dataStructure.getData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncTestVariableNode dsChildNode = (AsyncTestVariableNode)element$iv;
            boolean bl = false;
            this.processVariableNode(dsChildNode);
        }
    }
}

